/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.insurance;

import org.apache.commons.lang.builder.ToStringBuilder;

//----------------------------------------------------------------------------
//Import Framework classes
//----------------------------------------------------------------------------
import gov.va.med.fw.model.AbstractEntity;

//----------------------------------------------------------------------------
//  Import EDB classes
//----------------------------------------------------------------------------
import gov.va.med.esr.common.model.lookup.InsuredRelationship;

/**
 * This is a value object, not a persistent class. Don't operate it separately.
 * @author Commons Team 
 */
public class InsuranceSubscriber extends AbstractEntity
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -3194056354797898075L;
	private InsuredRelationship relationship = null;
    private String name = null;


    /**
     * Creates a new InsuranceSubscriber object.
     */
    public InsuranceSubscriber()
    {
        super();
    }

    public InsuredRelationship getRelationship()
    {
        return this.relationship;
    }

    public void setRelationship(InsuredRelationship relationship)
    {
        this.relationship = relationship;
    }

    public String getName()
    {
        return this.name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        builder.append("relationship", this.relationship);
        builder.append("name", this.name);
    }
}

