/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.insurance;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractEntity;

import gov.va.med.esr.common.model.lookup.InsurancePlanType;

/**
 * @author Commons Team
 * @version 1.0
 */
public class InsurancePlan
    extends AbstractEntity {
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 43123266149180798L;

	private InsurancePolicy   insurancePolicy          = null;

    /**
     * Type of insurance plan is defined as a type of insurance that an
     * insurance company is generally associated with.
     */
    private InsurancePlanType planType                 = null;

    /**
     * Pre-certification Indicator is defined as an indicator for the need to
     * get pre-certification.
     */
    private Boolean           precertificationRequired = null;

    /**
     * Creates a new InsurancePlan object.
     */
    public InsurancePlan() {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    public InsurancePolicy getInsurancePolicy() {
        return this.insurancePolicy;
    }

    public void setInsurancePolicy(InsurancePolicy insurancePolicy) {
        this.insurancePolicy = insurancePolicy;
    }

    public InsurancePlanType getPlanType() {
        return this.planType;
    }

    public void setPlanType(InsurancePlanType planType) {
        this.planType = planType;
    }

    public Boolean isPrecertificationRequired() {
        return this.precertificationRequired;
    }

    public Boolean getPrecertificationRequired() {
        return isPrecertificationRequired();
    }

    public void setPrecertificationRequired(Boolean precertificationRequired) {
        this.precertificationRequired = precertificationRequired;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        builder.append("planType", this.planType);
        builder.append("precertificationRequired", this.precertificationRequired);
    }
}