package gov.va.med.esr.common.model.hbp;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import gov.va.med.esr.common.model.lookup.HealthBenefitPlanCategory;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.security.CapabilitySet;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class HealthBenefitPlanName extends AbstractKeyedEntity implements Comparable<HealthBenefitPlanName> {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -60195805515658310L;

	//----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public HealthBenefitPlanCategory getPlanCategory() {
		return planCategory;
	}

	public void setPlanCategory(HealthBenefitPlanCategory planCategory) {
		this.planCategory = planCategory;
	}


	/**
	* Getter - for hibernate use only.
	*
	* @return
	*/
   private Set<HealthBenefitPlanDefinition> getInternalPlanDefinitions() {
      if( this.internalPlanDefinitions == null ) {
         this.internalPlanDefinitions = new HashSet<HealthBenefitPlanDefinition>();
      }
      return this.internalPlanDefinitions;
   }

   /**
	* Setter - for hibernate use only.
	*
	* @param internalPlanDefiniteions
	*/
   private void setInternalPlanDefinitions(Set<HealthBenefitPlanDefinition> internalPlanDefinitions) {
      this.internalPlanDefinitions = internalPlanDefinitions;
   }
   
   /**
	* Returns a collection of HealthBenefitPlanDefinition Objects.
	*
	* @return Set - Set of HealthBenefitPlanDefinition
	*/
   public Set<HealthBenefitPlanDefinition> getPlanDefinitions() {
      return Collections.unmodifiableSet(this.getInternalPlanDefinitions());
   }

   public void addPlanDefinition(HealthBenefitPlanDefinition planDefinition) {
      Validate.notNull(planDefinition, "Null Plan Definition specified.");
      planDefinition.setPlanName(this);
      this.getInternalPlanDefinitions().add(planDefinition);
   }

   public void removePlanDefinition(HealthBenefitPlanDefinition planDefinition) {
      Validate.notNull(planDefinition, "Null Plan Definition specified.");
      planDefinition.setPlanName(null);
      this.getInternalPlanDefinitions().remove(planDefinition);
   }
   
   /**
    * Returns a HealthBenefitPlanDefinition based on the entity key.
    *
    * @param identifier
    * @return HealthBenefitPlanDefinition
    */
   public HealthBenefitPlanDefinition getPlanDefinitionByEntityKey(EntityKey identifier) {
      return (HealthBenefitPlanDefinition)getEntityByEntityKey(getPlanDefinitions(), identifier);
   }


   public void removeAllPlanDefinitions() {
      this.getInternalPlanDefinitions().clear();
   }

	 public int compareTo(HealthBenefitPlanName o) {
	    if( o != null)
	       return getName().compareTo(o.getName());
	    else
	       return 1;
	 }

    //----------------------------------------------------------------------------
    // Package protected method(s)
    //----------------------------------------------------------------------------
 
    //----------------------------------------------------------------------------
    // Protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Private method(s)
    //----------------------------------------------------------------------------
     /*
      * (non-Javadoc)
      * 
      * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
      */
     protected void buildToString(ToStringBuilder builder) {
         super.buildToString(builder);
         builder.append("name", this.name);
         builder.append("planCategory", this.planCategory);
         builder.append("planDefinitions", this.getPlanDefinitions());
      }
     

    //----------------------------------------------------------------------------
    // All attributes that are not static
    //----------------------------------------------------------------------------
    private String name = null;
    private HealthBenefitPlanCategory planCategory;

	private Set<HealthBenefitPlanDefinition> internalPlanDefinitions = null;
 

 } //  End of HealthBenefitPlanName Class
