package gov.va.med.esr.common.model.hbp;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import gov.va.med.fw.model.AbstractKeyedEntity;

import org.apache.commons.lang.builder.ToStringBuilder;

public class HealthBenefitPlanDescription extends AbstractKeyedEntity implements Comparable<HealthBenefitPlanDescription> {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4374894072844507241L;
	
	//----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------
   public HealthBenefitPlanDefinition getPlanDefinition() {
        return this.planDefinition;
    }

    public void setPlanDefinition(HealthBenefitPlanDefinition planDefinition) {
        this.validateOwner(this.planDefinition,planDefinition);
        this.planDefinition = planDefinition;
    }
	 

    public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	/*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("description", this.description);
     }

	 public int compareTo(HealthBenefitPlanDescription o) {
		    if( o != null)
		       return getDescription().compareTo(o.getDescription());
		    else
		       return 1;
		 }

    //----------------------------------------------------------------------------
    // Package protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Private method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // All attributes that are not static
    //----------------------------------------------------------------------------
    private String description = null;
    private HealthBenefitPlanDefinition planDefinition = null;

 } //  End of HealthBenefitPlanName Class
