package gov.va.med.esr.common.model.hbp;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.StringUtils;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang.builder.ToStringBuilder;


public class HealthBenefitPlanDefinition extends AbstractKeyedEntity implements Comparable<HealthBenefitPlanDefinition> {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7555944516436868437L;

	//----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    public HealthBenefitPlanName getPlanName() {
		return planName;
	}

    public void setPlanName(HealthBenefitPlanName planName) {
        this.validateOwner(this.planName,planName);
		this.planName = planName;
	}

	public String getPlanCode() {
		return planCode;
	}

	public void setPlanCode(String planCode) {
		this.planCode = planCode;
	}

	public String getCoverageCode() {
		return coverageCode;
	}

	public void setCoverageCode(String coverageCode) {
		this.coverageCode = coverageCode;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public Date getExpirationDate() {
		return expirationDate;
	}

	public void setExpirationDate(Date expirationDate) {
		this.expirationDate = expirationDate;
	}

	public Boolean getAutomated() {
		return automated;
	}

	public void setAutomated(Boolean automated) {
		this.automated = automated;
	}

	public void isAutomated(Boolean automated) {
		this.automated = automated;
	}

	private Set<HealthBenefitPlanDescription> getInternalPlanDescriptions() {
      if( internalPlanDescriptions == null ) {
         this.internalPlanDescriptions = new HashSet<HealthBenefitPlanDescription>();
      }
      return this.internalPlanDescriptions;
	}

	private void setInternalPlanDescriptions(Set<HealthBenefitPlanDescription> internalPlanDescriptions) {
      this.internalPlanDescriptions = internalPlanDescriptions;
	}

	public HealthBenefitPlanDescription getPlanDescription() {
      Set<HealthBenefitPlanDescription> descriptions = getInternalPlanDescriptions();
      return descriptions.size() > 0 ? (HealthBenefitPlanDescription)descriptions.iterator().next()
            : null;
	}

	public void setPlanDescription(HealthBenefitPlanDescription description) {
      Set<HealthBenefitPlanDescription> descriptions = getInternalPlanDescriptions();
      Iterator<HealthBenefitPlanDescription> iter = descriptions.iterator();
      if( iter.hasNext() ) {
    	  HealthBenefitPlanDescription o = (HealthBenefitPlanDescription)iter.next();
    	  descriptions.remove(o);
         o.setPlanDefinition(null);
      }
      if( description != null ) {
    	  descriptions.add(description);
    	  description.setPlanDefinition(this);
      }
	}

    public int compareTo(HealthBenefitPlanDefinition o) {
        if ( o != null) {
        	if (!StringUtils.isEmpty(this.getCoverageCode())) {
        		// try to compare coverage code first
        		return getCoverageCode().compareTo(o.getCoverageCode());
        	} else {
        		if (!StringUtils.isEmpty(o.getCoverageCode())) {
        			return -1;
        		} else {
        			// neither has coverage code, compare description
        			return getPlanDescription().compareTo(o.getPlanDescription());
        		}
        	}
         }
        else
           return 1;
     }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("planCode", this.planCode);
        builder.append("coverageCode", this.coverageCode);
        builder.append("description", this.getPlanDescription());
        builder.append("effectiveDate", this.effectiveDate);
        builder.append("expirationDate", this.expirationDate);
        builder.append("automated", this.automated);
    }

    //----------------------------------------------------------------------------
    // Package protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Private method(s)
    //----------------------------------------------------------------------------


	//----------------------------------------------------------------------------
    // All attributes that are not static
    //----------------------------------------------------------------------------
    private HealthBenefitPlanName planName;
    private String planCode;
    private String coverageCode;
    private Date effectiveDate = null;
    private Date expirationDate = null;
    private Boolean automated = Boolean.FALSE;
    
    private Set<HealthBenefitPlanDescription> internalPlanDescriptions = null;


 } //  End of HealthBenefitPlanDefinition Class
