/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.financials;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Spouse;

/**
 * @author Commons Team
 * @version 1.0
 */
public class SpouseFinancials
    extends RelationFinancials {

    /**
     * An instance of serialVersionUID
     */
    private static final long  serialVersionUID   = 7818421624202507260L;

    private Spouse reportedOn         = null;

    /**
     * Creates a new SpouseFinancials object.
     */
    public SpouseFinancials() {
        super();
    }

    public SpouseFinancials(Spouse spouse) {
        this();
        setReportedOn(spouse);
    }
    
    public void setPerson(Person person) {
        super.setPerson(person);
        if (reportedOn != null) {
            reportedOn.setPerson(person);
        }
    }

    public Spouse getReportedOn() {
        return this.reportedOn;
    }

    public void setReportedOn(Spouse reportedOn) {
        this.reportedOn = reportedOn;
        setRelationPerson(reportedOn);
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("reportedOn", reportedOn);
    }
    
    protected Date getEndDate() { 
        return this.reportedOn != null ? this.reportedOn.getEndDate() : null;
    }
}

