/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.financials;

//----------------------------------------------------------------------------
//  Import third party library classes
//----------------------------------------------------------------------------
import java.util.Date;
import java.util.Iterator;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.util.DateUtils;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Relation;

/**
 * @author Commons Team
 * @version 1.0
 */
public abstract class RelationFinancials
    extends FinancialInformation {
    
    private static final long serialVersionUID = -1370346746640850300L;
    private FinancialStatement financialStatement = null;

    /**
     * Lived with patient is defined as an Indicator whether spouse lived with
     * patient during last calendar year. If the veteran and spouse were living
     * apart because one is hospitalized or in a nursing home select yes. If
     * Married last calendar year is NO, this attribute does not apply Yes/No
     */
    private Boolean            livedWithPatient   = null;
    private Boolean            validDependent     = null;
    
    private Date               endDate             = null;

    /**
     * Creates a new SpouseFinancials object.
     */
    public RelationFinancials() {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------
    public FinancialStatement getFinancialStatement() {
        return financialStatement;
    }

    protected void setFinancialStatement(FinancialStatement financialStatement) {
        this.financialStatement = financialStatement;
        if (financialStatement != null) {
            setIncomeYear(financialStatement.getIncomeYear());
            setPerson(financialStatement.getPerson());
        }
    }
    
    private void setRelationPerson(RelationFinancials relationFinancials, Person person) {
        relationFinancials.setPerson(person);
        this.setEndDate(relationFinancials.getEndDate());
    }

    public Boolean getLivedWithPatient() {
        return this.livedWithPatient;
    }

    public void setLivedWithPatient(Boolean livedWithPatient) {
        this.livedWithPatient = livedWithPatient;
    }

    public Boolean getValidDependent() {
        return validDependent;
    }

    public void setValidDependent(Boolean validDependent) {
        this.validDependent = validDependent;
    }
    
    public boolean isActive() {
        Date incomeYearEndDate = DateUtils.getYearEndDate(getIncomeYear().intValue());        
        if(getEndDate() == null || getEndDate().compareTo(incomeYearEndDate) >= 0){ 
            return true;
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("livedWithPatient", this.livedWithPatient);
    }

    protected void setRelationPerson(Relation relation) {
        if (relation != null) {
            relation.setPerson(getPerson());
        }
    }
    
   
    
    protected Date getEndDate() { 
    	return endDate; }
    
    protected void setEndDate(Date endDate){
    	this.endDate = endDate;
    }
}

