package gov.va.med.esr.common.model.financials;

//Java Classes

//Library Classes

//Framework Classes
import gov.va.med.fw.model.AbstractEntity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.builder.ToStringBuilder;

// Common classes

/**
 * 
 * @author DNS   CHENJ2
 * @version 1.0
 */
public class IncomeThreshold extends AbstractEntity {

	private static final long serialVersionUID = 6012566047639863793L;
    private static final String	EMPTY_STR					= "";
	public static final String	QUERY_FIND_BY_YEAR			= "incomeThreshold_getByYear";
	public static final String	QUERY_FIND_ALL				= "incomeThreshold_getAll";
	public static final String	QUERY_PARAM_YEAR			= "year";
	
	private BigDecimal			aaThreshold             	= null;
	private BigDecimal			add90DayHospitalDeductible	= null;
	private BigDecimal			addDependentPension			= null;
	private BigDecimal			addDependentThreshold		= null;
	private BigDecimal			childIncomeExclusion		= null;
	private BigDecimal			dependent					= null;
	private BigDecimal			exemptAmount				= null;
	private BigDecimal			gmtInpatient90DayCopay		= null;
	private BigDecimal			gmtInpatientAdd90DayCopay	= null;
	private BigDecimal			gmtInpatientPerDiem			= null;
	private BigDecimal			identifier					= null;
	private BigDecimal			inpatientPerDiem			= null;
	private BigDecimal			ltcDomiciliaryCopay			= null;
	private BigDecimal			ltcInpatientCopay			= null;
	private BigDecimal			ltcOutpatientCopay			= null;
	private BigDecimal			medicalExpenseDeductible	= null;
	private BigDecimal			medicationCopay				= null;
	private BigDecimal			medicationCopayAnnualCap	= null;
	private Map					medicalDeductibles			= new HashMap(8);
	private Map					mtThresholds				= new HashMap(8);
	private BigDecimal			ninetyDayHospitalCopay		= null;
	private BigDecimal			nursing90DayDeductible		= null;
	private BigDecimal			outpatientPreventiveCopay	= null;
	private BigDecimal			outpatientSpecialtyCopay	= null;
	private BigDecimal			outpatientCopay				= null;
	private Map					pensionThresholds			= new HashMap(8);
	private BigDecimal			pensionThreshold			= null;
	private BigDecimal			pension1Dependent			= null;
	private BigDecimal			propertyThreshold			= null;
    private Date                thresholdEffectiveDate      = null;
	private Integer				year						= null;

	/**
	 * Default constructor.
	 */
	public IncomeThreshold() {
		super();
	}

	/**
	 * Returns the unique identifier for this object.
	 * 
	 * @return The unique identifier for this object.
	 */
	public BigDecimal getIdentifier() {
		return this.identifier;
	}

	/**
	 * Sets the unique identifier for this object.
	 * 
	 * @param identifier
	 *            The unique identifier for this object.
	 */
	private void setIdentifier(BigDecimal identifier) {
		this.identifier = identifier;
	}

	/**
	 * @return
	 */
	public Integer getYear() {
		return year;
	}

	/**
	 * @param year
	 */
	private void setYear(Integer year) {
		this.year = year;
	}


	public BigDecimal getAaThreshold() {
		return this.aaThreshold;
	}

	/* Hibernate use */
	private void setAaThreshold( BigDecimal aaThreshold) {
		this.aaThreshold = aaThreshold;
	}
	
	/**
	 * @param numberOfDependents
	 * @return
	 */
	public BigDecimal getMeansTestThresholdValue(int numberOfDependents) {
		return (BigDecimal) mtThresholds.get(EMPTY_STR + numberOfDependents);
	}

	/**
	 * @param numberOfDependents
	 * @param thresholdValue
	 */
	public void setMeansTestThresholdValue(int numberOfDependents,
			BigDecimal thresholdValue) {
		mtThresholds.put(EMPTY_STR + numberOfDependents, thresholdValue);
	}

	/**
	 * @param numberOfDependents
	 * @return
	 */
	public BigDecimal getPensionThresholdValue(int numberOfDependents) {
		return (BigDecimal) pensionThresholds.get(EMPTY_STR
				+ numberOfDependents);
	}

	/**
	 * @param numberOfDependents
	 * @param thresholdValue
	 */
	public void setPensionThresholdValue(int numberOfDependents,
			BigDecimal thresholdValue) {
		pensionThresholds.put(EMPTY_STR + numberOfDependents, thresholdValue);
	}

	/**
	 * @param numberOfDependents
	 * @return
	 */
	public BigDecimal getMedicalDeductiblesValue(int numberOfDependents) {
		return (BigDecimal) medicalDeductibles.get(EMPTY_STR
				+ numberOfDependents);
	}

	/**
	 * @param numberOfDependents
	 * @param thresholdValue
	 */
	public void setMedicalDeductiblesValue(int numberOfDependents,
			BigDecimal thresholdValue) {
		medicalDeductibles.put(EMPTY_STR + numberOfDependents, thresholdValue);
	}

	/**
	 * @return
	 */
	public BigDecimal getAdd90DayHospitalDeductible() {
		return add90DayHospitalDeductible;
	}

	/**
	 * @param add90DayHospitalDeductible
	 */
	private void setAdd90DayHospitalDeductible(
			BigDecimal add90DayHospitalDeductible) {
		this.add90DayHospitalDeductible = add90DayHospitalDeductible;
	}

	/**
	 * @return
	 */
	public BigDecimal getAddDependentPension() {
		return addDependentPension;
	}

	/**
	 * @param addDependentPension
	 */
	private void setAddDependentPension(BigDecimal addDependentPension) {
		this.addDependentPension = addDependentPension;
	}

	/**
	 * @return
	 */
	public BigDecimal getAddDependentThreshold() {
		return addDependentThreshold;
	}

	/**
	 * @param addDependentThreshold
	 */
	private void setAddDependentThreshold(BigDecimal addDependentThreshold) {
		this.addDependentThreshold = addDependentThreshold;
	}

	/**
	 * @return
	 */
	public BigDecimal getChildIncomeExclusion() {
		return childIncomeExclusion;
	}

	/**
	 * @param childIncomeExclusion
	 */
	private void setChildIncomeExclusion(BigDecimal childIncomeExclusion) {
		this.childIncomeExclusion = childIncomeExclusion;
	}

	/**
	 * @return
	 */
	public BigDecimal getDependent() {
		return dependent;
	}

	/**
	 * @param dependent
	 */
	private void setDependent(BigDecimal dependent) {
		this.dependent = dependent;
		// MT threshold for vet with 1 dependent
		mtThresholds.put(EMPTY_STR + 1, dependent);
	}

	/**
	 * @return
	 */
	public BigDecimal getExemptAmount() {
		return exemptAmount;
	}

	/**
	 * @param exemptAmount
	 */
	private void setExemptAmount(BigDecimal exemptAmount) {
		this.exemptAmount = exemptAmount;
		// MT threshold for vet with no dependent
		mtThresholds.put(EMPTY_STR + 0, exemptAmount);
	}

	/**
	 * @return
	 */
	public BigDecimal getMedicalExpenseDeductible() {
		return medicalExpenseDeductible;
	}

	/**
	 * @param medicalExpenseDeductible
	 */
	private void setMedicalExpenseDeductible(BigDecimal medicalExpenseDeductible) {
		this.medicalExpenseDeductible = medicalExpenseDeductible;
	}

	/**
	 * @return
	 */
	public BigDecimal getNinetyDayHospitalCopay() {
		return ninetyDayHospitalCopay;
	}

	/**
	 * @param ninetyDayHospitalCopay
	 */
	private void setNinetyDayHospitalCopay(BigDecimal ninetyDayHospitalCopay) {
		this.ninetyDayHospitalCopay = ninetyDayHospitalCopay;
	}

	/**
	 * @return Returns the inpatientPerDiem.
	 */
	public BigDecimal getInpatientPerDiem() {
		return inpatientPerDiem;
	}

	/**
	 * @param inpatientPerDiem
	 *            The inpatientPerDiem to set.
	 */
	private void setInpatientPerDiem(BigDecimal inpatientPerDiem) {
		this.inpatientPerDiem = inpatientPerDiem;
	}

	/**
	 * @return Returns the gmtInpatient90DayCopay.
	 */
	public BigDecimal getGmtInpatient90DayCopay() {
		return gmtInpatient90DayCopay;
	}

	/**
	 * @param gmtInpatient90DayCopay
	 *            The gmtInpatient90DayCopay to set.
	 */
	public void setGmtInpatient90DayCopay(BigDecimal gmtInpatient90DayCopay) {
		this.gmtInpatient90DayCopay = gmtInpatient90DayCopay;
	}

	/**
	 * @return Returns the gmtInpatientAdd90DayCopay.
	 */
	public BigDecimal getGmtInpatientAdd90DayCopay() {
		return gmtInpatientAdd90DayCopay;
	}

	/**
	 * @param gmtInpatientAdd90DayCopay
	 *            The gmtInpatientAdd90DayCopay to set.
	 */
	public void setGmtInpatientAdd90DayCopay(
			BigDecimal gmtInpatientAdd90DayCopay) {
		this.gmtInpatientAdd90DayCopay = gmtInpatientAdd90DayCopay;
	}

	/**
	 * @return Returns the gmtInpatientPerDiem.
	 */
	public BigDecimal getGmtInpatientPerDiem() {
		return gmtInpatientPerDiem;
	}

	/**
	 * @param gmtInpatientPerDiem
	 *            The gmtInpatientPerDiem to set.
	 */
	public void setGmtInpatientPerDiem(BigDecimal gmtInpatientPerDiem) {
		this.gmtInpatientPerDiem = gmtInpatientPerDiem;
	}

	/**
	 * @return
	 */
	public BigDecimal getNursing90DayDeductible() {
		return nursing90DayDeductible;
	}

	/**
	 * @param nursing90DayDeductible
	 */
	private void setNursing90DayDeductible(BigDecimal nursing90DayDeductible) {
		this.nursing90DayDeductible = nursing90DayDeductible;
	}

	/**
	 * @return
	 */
	public BigDecimal getOutpatientCopay() {
		return outpatientCopay;
	}

	/**
	 * @param outpatientCopay
	 */
	private void setOutpatientCopay(BigDecimal outpatientCopay) {
		this.outpatientCopay = outpatientCopay;
	}

	/**
	 * @return
	 */
	public BigDecimal getOutpatientSpecialtyCopay() {
		return outpatientSpecialtyCopay;
	}

	/**
	 * @param outpatientSpecialtyCopay
	 */
	private void setOutpatientSpecialtyCopay(BigDecimal outpatientSpecialtyCopay) {
		this.outpatientSpecialtyCopay = outpatientSpecialtyCopay;
	}

	/**
	 * @return
	 */
	public BigDecimal getPension1Dependent() {
		return pension1Dependent;
	}

	/**
	 * @param pension1Dependent
	 */
	private void setPension1Dependent(BigDecimal pension1Dependent) {
		this.pension1Dependent = pension1Dependent;
	}

	/**
	 * @return
	 */
	public BigDecimal getPensionThreshold() {
		return pensionThreshold;
	}

	/**
	 * @param pensionThreshold
	 */
	private void setPensionThreshold(BigDecimal pensionThreshold) {
		this.pensionThreshold = pensionThreshold;
	}

	/**
	 * @return
	 */
	public BigDecimal getPropertyThreshold() {
		return propertyThreshold;
	}

	/**
	 * @param propertyThreshold
	 */
	private void setPropertyThreshold(BigDecimal propertyThreshold) {
		this.propertyThreshold = propertyThreshold;
	}

	/**
	 * @return
	 */
	public Date getThresholdEffectiveDate() {
		return thresholdEffectiveDate;
	}

	/**
	 * @param thresholdEffectiveDate
	 */
	private void setThresholdEffectiveDate(Date thresholdEffectiveDate) {
		this.thresholdEffectiveDate = thresholdEffectiveDate;
	}

	/**
	 * @return Returns the ltcDomiciliaryCopay.
	 */
	public BigDecimal getLtcDomiciliaryCopay() {
		return ltcDomiciliaryCopay;
	}

	/**
	 * @param ltcDomiciliaryCopay
	 *            The ltcDomiciliaryCopay to set.
	 */
	private void setLtcDomiciliaryCopay(BigDecimal ltcDomiciliaryCopay) {
		this.ltcDomiciliaryCopay = ltcDomiciliaryCopay;
	}

	/**
	 * @return Returns the ltcInpatientCopay.
	 */
	public BigDecimal getLtcInpatientCopay() {
		return ltcInpatientCopay;
	}

	/**
	 * @param ltcInpatientCopay
	 *            The ltcInpatientCopay to set.
	 */
	private void setLtcInpatientCopay(BigDecimal ltcInpatientCopay) {
		this.ltcInpatientCopay = ltcInpatientCopay;
	}

	/**
	 * @return Returns the ltcOutpatientCopay.
	 */
	public BigDecimal getLtcOutpatientCopay() {
		return ltcOutpatientCopay;
	}

	/**
	 * @param ltcOutpatientCopay
	 *            The ltcOutpatientCopay to set.
	 */
	private void setLtcOutpatientCopay(BigDecimal ltcOutpatientCopay) {
		this.ltcOutpatientCopay = ltcOutpatientCopay;
	}

	/**
	 * @return Returns the medicationCopay.
	 */
	public BigDecimal getMedicationCopay() {
		return medicationCopay;
	}

	/**
	 * @param medicationCopay
	 *            The medicationCopay to set.
	 */
	private void setMedicationCopay(BigDecimal medicationCopay) {
		this.medicationCopay = medicationCopay;
	}

	/**
	 * @return Returns the medicationCopayAnnualCap.
	 */
	public BigDecimal getMedicationCopayAnnualCap() {
		return medicationCopayAnnualCap;
	}

	/**
	 * @param medicationCopayAnnualCap
	 *            The medicationCopayAnnualCap to set.
	 */
	private void setMedicationCopayAnnualCap(BigDecimal medicationCopayAnnualCap) {
		this.medicationCopayAnnualCap = medicationCopayAnnualCap;
	}

	/**
	 * @return Returns the outpatientPreventiveCopay.
	 */
	public BigDecimal getOutpatientPreventiveCopay() {
		return outpatientPreventiveCopay;
	}

	/**
	 * @param outpatientPreventiveCopay
	 *            The outpatientPreventiveCopay to set.
	 */
	private void setOutpatientPreventiveCopay(
			BigDecimal outpatientPreventiveCopay) {
		this.outpatientPreventiveCopay = outpatientPreventiveCopay;
	}

	protected void buildToString(ToStringBuilder builder) {
		builder.append("year", year);
		builder.append("aaThreshold", aaThreshold);
		builder.append("exemptAmount", exemptAmount);
		builder.append("medicalExpenseDeductible ", medicalExpenseDeductible);
		builder.append("childIncomeExclusion", childIncomeExclusion);
		builder.append("dependent", dependent);
		builder.append("addDependentThreshold", addDependentThreshold);
		builder.append("propertyThreshold", propertyThreshold);
		builder.append("pensionThreshold", pensionThreshold);
		builder.append("pension1Dependent", pension1Dependent);
		builder.append("addDependentPension", addDependentPension);
		builder.append("ninetyDayHospitalCopay", ninetyDayHospitalCopay);
		builder
				.append("add90DayHospitalDeductible",
						add90DayHospitalDeductible);
		builder.append("outpatientSpecialtyCopay", outpatientSpecialtyCopay);
		builder.append("outpatientCopay", outpatientCopay);
		builder.append("thresholdEffectiveDate", thresholdEffectiveDate);
        for (int i = 0; i < mtThresholds.size(); i++) {
            builder.append("MeansTestThreshold Dep"+i, getMeansTestThresholdValue(i));
        }
        for (int i = 0; i < medicalDeductibles.size(); i++) {
            builder.append("MedicalExpDeductible Dep"+i, getMedicalDeductiblesValue(i));
        }
        for (int i = 0; i < pensionThresholds.size(); i++) {
            builder.append("PensionThreshold Dep"+i, getPensionThresholdValue(i));
        }
	}
}