/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on 12/9/2004
 */
package gov.va.med.esr.common.model.financials;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;

/**
 * @author Commons Team
 * @version 1.0
 */
public class IncomeTestStatus
    extends AbstractKeyedEntity {
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = 7397805884777812145L;

    private IncomeTest        incomeTest       = null;

    /**
     * Date/time completed is defined as the date/time that the test was
     * completed. This field is used to indicate when a veteran agreed to pay
     * co-payment, and is used for billing purposes. Date must be precise.
     * Cannot be a Future Date
     */
    private Date              completedDate    = null;

    /**
     * Date/Time last edited is defined as the date/time the test was last
     * edited
     */
    private Date              lastEditedDate   = null;

    /**
     * Type of Test is defined as the type of test associated with the financial
     * test. Choices: Means Test, Pharmacy Co-pay Test , Long Term Care Copay,
     * Exemption Test - type 4 test, LTC copay test - Type 3 test.
     */
    private IncomeTestType    type             = null;

    /**
     * Can be one of the following:
     * 
     * Means Test Status is defined as the status for the type of test MT. The
     * choices are:MT Copay Exempt, MT Copay Required, No Longer Required,
     * Required, Pending Adjudication, GMT Copay required.
     * 
     * Pharmacy copay status is defined as the status for the type of test
     * Pharmacy copay Test. The acceptable choices are: Exempt, Non-Exempt,
     * Incomplete, No Longer Applicable.
     * 
     * Long Term Care status is defined as the status of the type of test LTC
     * suppliedThe acceptable choices are:ExemptNon Exempt
     */
    private MeansTestStatus   status           = null;

    /**
     * Test- determined Status is defined as Once the test is completed, this
     * field will indicate the status based on income screening and net worth
     * adjudication
     * 
     * This field will be used to record the status determined by the income
     * screening or net worth adjudication. It will not change as the result of
     * a hardship determination or changes in eligibility. It will be used to
     * automatically re-complete the test if the test is again required after
     * going to a status which indicates that it is not required based on
     * changes in eligibility
     * 
     * Choices are:
     * 
     * LTC Test statuses: Exempt, Non-exempt
     * 
     * RX Copay test statuses: Exempt, Non-exempt, Incomplete, No longer
     * applicable
     * 
     * MT test statuses: MT Copay Exempt, MT Copay Required, No Longer Required,
     * Required Pending Adjudication, GMT Copay Required
     */
    private MeansTestStatus   determinedStatus = null;

    /**
     * Creates a new IncomeTestStatus object.
     */
    public IncomeTestStatus() {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    public IncomeTest getIncomeTest() {
        return this.incomeTest;
    }

    public void setIncomeTest(IncomeTest incomeTest) {
        this.validateOwner(this.incomeTest,incomeTest);        
    	this.incomeTest = incomeTest;
    }

    public Date getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
    }

    public Date getLastEditedDate() {
        return this.lastEditedDate;
    }

    public void setLastEditedDate(Date lastEditedDate) {
        this.lastEditedDate = lastEditedDate;
    }

    public IncomeTestType getType() {
        return this.type;
    }

    public void setType(IncomeTestType type) {
        this.type = type;
    }

    public MeansTestStatus getStatus() {
        return this.status;
    }

    public void setStatus(MeansTestStatus status) {
        this.status = status;
    }

    public MeansTestStatus getDeterminedStatus() {
        return this.determinedStatus;
    }

    public void setDeterminedStatus(MeansTestStatus determinedStatus) {
        this.determinedStatus = determinedStatus;
    }


    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("completedDate", this.completedDate);
        builder.append("lastEditedDate", this.lastEditedDate);
        builder.append("type", this.type);
        builder.append("status", this.status);
        builder.append("determinedStatus", this.determinedStatus);
    }

}