/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.financials;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import gov.va.med.esr.common.model.lookup.IncomeType;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 
 * @author Commons Team
 * @author DNS   mansog
 * @version 1.0
 */
public class Income
    extends Financial {
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = -6382825487732311040L;

    private IncomeType        type             = null;

    /**
     * Creates a new Income object.
     */
    public Income() {
        super();
    }

    /**
     * @param amount
     */
    public Income(BigDecimal amount) {
        super(amount);
    }
    
    public IncomeType getType() {
        return this.type;
    }

    protected void setType(IncomeType type) {
        this.type = type;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("type", this.type);
    }

    /**
     * Helper method to get the Income of a given type code.
     * This method iterates the collection of incomes and return 
     * the Income of give type code or null if no income for a given 
     * type code exists.
     * 
     * @param incomes
     * @param typeCode
     * @return Income if found or null if no Income with a given type found.
     */
    public static Income getIncomeOfType(Collection incomes, IncomeType.Code typeCode) {
		Validate.notNull(incomes, "The set of incomes must not be null");
		Validate.notNull(typeCode, "Income type code must not be null");
        for (Iterator iter = incomes.iterator(); iter.hasNext();) {
            Income income = (Income) iter.next();
            IncomeType incomeType = income.getType();
            if (incomeType != null 
                    && incomeType.getCode().equals(typeCode.getName())) {
                return income;
            }
        }
        return null;
    }
}