/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.financials;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * InProcessFinancialInfo
 * @time   Jul 11, 2006 7:22:28 PM
 * @author DNS   MANSOG
 */
public class InProcessFinancialInfo extends AbstractKeyedEntity {

    private static final long serialVersionUID = 365960394067672127L;
    private Person  person        = null;
    private Integer incomeYear    = null;
    private String  inProcessData = null;

    public InProcessFinancialInfo() {
        super();
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person, person);
        this.person = person;
    }

    /**
     * getIncomeYear
     * @return
     */
    public Integer getIncomeYear() {
        return this.incomeYear;
    }

    /**
     * setIncomeYear
     * @param incomeYear
     */
    public void setIncomeYear(Integer incomeYear) {
        this.incomeYear = incomeYear;
    }

    /**
     * @return Returns the inProcessData.
     */
    public String getInProcessData() {
        return inProcessData;
    }

    /**
     * @param inProcessData
     *            The inProcessData to set.
     */
    public void setInProcessData(String inProcessData) {
        this.inProcessData = inProcessData;
    }

    /**
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("incomeYear", this.incomeYear);
        builder.append("inProcessData", this.inProcessData);
    }
}