/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.financials;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import java.util.Date;

//----------------------------------------------------------------------------
//  Import third party library classes
//----------------------------------------------------------------------------
import org.apache.commons.lang.builder.ToStringBuilder;

//----------------------------------------------------------------------------
//Import Framework classes
//----------------------------------------------------------------------------
import gov.va.med.fw.model.AbstractEntity;

//----------------------------------------------------------------------------
//  Import EDB classes
//----------------------------------------------------------------------------
import gov.va.med.esr.common.model.lookup.VAFacility;

/**
 * 
 * 
 * @author Commons Team
 *  
 */
public class Hardship
    extends AbstractEntity {
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID     = 9051266061554337716L;

    /**
     * Hardship Indicator is defined as the indicator that identifies that the
     * veteran has a hardship applied. Values are YES/NO
     */
    private Boolean           hardshipGranted      = null;

    /**
     * Hardship Review Date is defined as the date the hardship should be
     * reviewed. Date must be precise
     */
    private Date              reviewDate           = null;

    /**
     * Hardship effective date is defined as the date when the hardship is
     * effective.Date must be precise
     */
    private Date              effectiveDate        = null;

    private VAFacility        siteGrantingHardship = null;

    /**
     * Hardship reason is defined as a reason this person has been granted a
     * hardship.
     */
    private String            reason               = null;

    /**
     * Creates a new Hardship object.
     */
    public Hardship() {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------
    public Boolean getHardshipGranted() {
        return hardshipGranted;
    }

    public void setHardshipGranted(Boolean hardshipGranted) {
        this.hardshipGranted = hardshipGranted;
    }

    public Date getReviewDate() {
        return this.reviewDate;
    }

    public void setReviewDate(Date reviewDate) {
        this.reviewDate = reviewDate;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public VAFacility getSiteGrantingHardship() {
        return this.siteGrantingHardship;
    }

    public void setSiteGrantingHardship(VAFacility siteGrantingHardship) {
        this.siteGrantingHardship = siteGrantingHardship;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        builder.append("hardshipGranted", this.hardshipGranted).append(
                "reviewDate", this.reviewDate).append("effectiveDate",
                this.effectiveDate).append("reason", this.reason);
    }
}