package gov.va.med.esr.common.model.financials;

// Java Classes

// Library Classes

// Framework Classes
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * @author DNS   MANSOG
 * @version 1.0
 */
public class GMTThreshold extends AbstractKeyedEntity {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6254892226342934951L;

	private static final String EMPTY_STR = "";

	public static final String QUERY_FIND_BY_YEAR_FIPS = "gmtThreshold_getByYearAndFipsCode";

	public static final String QUERY_FIND_BY_YEAR_FIPS_MSA = "gmtThreshold_getByYearFipsAndMSACode";
	
	public static final String DEFAULT_MSA_CODE = "9999";

	public static final String QUERY_PARAM_YEAR = "year";

	public static final String QUERY_PARAM_FIPS_CODE = "countyCode";

	public static final String QUERY_PARAM_MSA_CODE = "msaCode";

	private Integer year = null;

	private String countyCode = null;

	private String msaCode = null;

	private Date effectiveDate = null;

	private Map thresholds = new HashMap(8);

	/**
	 * Default constructor.
	 */
	public GMTThreshold() {
		super();
	}

	public String getCountyCode() {
		return countyCode;
	}

	public void setCountyCode(String countyCode) {
		this.countyCode = countyCode;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getMsaCode() {
		return msaCode;
	}

	public void setMsaCode(String msaCode) {
		this.msaCode = msaCode;
	}

	public BigDecimal getThresholdValue(int numberOfDependents) {
		return (BigDecimal) thresholds.get(EMPTY_STR + numberOfDependents);
	}

	public void setThresholdValue(int numberOfDependents,
			BigDecimal thresholdValue) {
		thresholds.put(EMPTY_STR + numberOfDependents, thresholdValue);
	}

	private BigDecimal getThreshold0Dep() {
		return (BigDecimal) thresholds.get(EMPTY_STR + 0);
	}

	private void setThreshold0Dep(BigDecimal threshold0Dep) {
		thresholds.put(EMPTY_STR + 0, threshold0Dep);
	}

	private BigDecimal getThreshold1Dep() {
		return (BigDecimal) thresholds.get(EMPTY_STR + 1);
	}

	private void setThreshold1Dep(BigDecimal threshold1Dep) {
		thresholds.put(EMPTY_STR + 1, threshold1Dep);
	}

	private BigDecimal getThreshold2Dep() {
		return (BigDecimal) thresholds.get(EMPTY_STR + 2);
	}

	private void setThreshold2Dep(BigDecimal threshold2Dep) {
		thresholds.put(EMPTY_STR + 2, threshold2Dep);
	}

	private BigDecimal getThreshold3Dep() {
		return (BigDecimal) thresholds.get(EMPTY_STR + 3);
	}

	private void setThreshold3Dep(BigDecimal threshold3Dep) {
		thresholds.put(EMPTY_STR + 3, threshold3Dep);
	}

	private BigDecimal getThreshold4Dep() {
		return (BigDecimal) thresholds.get(EMPTY_STR + 4);
	}

	private void setThreshold4Dep(BigDecimal threshold4Dep) {
		thresholds.put(EMPTY_STR + 4, threshold4Dep);
	}

	private BigDecimal getThreshold5Dep() {
		return (BigDecimal) thresholds.get(EMPTY_STR + 5);
	}

	private void setThreshold5Dep(BigDecimal threshold5Dep) {
		thresholds.put(EMPTY_STR + 5, threshold5Dep);
	}

	private BigDecimal getThreshold6Dep() {
		return (BigDecimal) thresholds.get(EMPTY_STR + 6);
	}

	private void setThreshold6Dep(BigDecimal threshold6Dep) {
		thresholds.put(EMPTY_STR + 6, threshold6Dep);
	}

	private BigDecimal getThreshold7Dep() {
		return (BigDecimal) thresholds.get(EMPTY_STR + 7);
	}

	private void setThreshold7Dep(BigDecimal threshold7Dep) {
		thresholds.put(EMPTY_STR + 7, threshold7Dep);
	}

	public Integer getYear() {
		return year;
	}

	public void setYear(Integer year) {
		this.year = year;
	}

	protected void buildToString(ToStringBuilder builder) {
		builder.append("year", year);
		builder.append("countyCode", countyCode);
		builder.append("msaCode", msaCode);
		builder.append("effectiveDate", effectiveDate);
		for (int i = 0; i < thresholds.size(); i++) {
			builder.append("ThresholdDep" + i, getThresholdValue(i));
		}
	}
}