/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.financials;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import java.math.BigDecimal;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * @author DNS   mansog
 * @version 1.0
 */
public abstract class Financial
    extends AbstractKeyedEntity
{
    private static final long serialVersionUID = -1370346746640850300L;
    private FinancialInformation financialInformation = null;
    private BigDecimal amount = null;

	/**
     * Creates a new Income object.
     */
    public Financial()
    {
        super();
    }

    /**
     * Construct using Amount
     * @param amount
     */
    public Financial(BigDecimal amount) {
        setAmount(amount);
    }
    
    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------
    protected FinancialInformation getFinancialInformation()
    {
        return this.financialInformation;
    }

    protected void setFinancialInformation(
        FinancialInformation financialInformation)
    {
        validateOwner(this.financialInformation, financialInformation);
        this.financialInformation = financialInformation;
    }

    public BigDecimal getAmount()
    {
        return this.amount;
    }

    public void setAmount(BigDecimal amount)
    {
        this.amount = amount;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);
        builder.append("amount", this.amount);
    }
}
