/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.financials;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import gov.va.med.esr.common.model.lookup.ExpenseType;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author Commons Team
 * @author DNS   mansog
 * @version 1.0
 */
public class Expense
    extends Financial {
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = -5913653844253658808L;

    private ExpenseType       type             = null;

    /**
     * Creates a new Expense object.
     */
    public Expense() {
        super();
    }
    
    /**
     * @param amount
     */
    public Expense(BigDecimal amount) {
        super(amount);
    }
    
    public ExpenseType getType() {
        return this.type;
    }

    protected void setType(ExpenseType type) {
        this.type = type;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("type", this.type);
    }

    /**
     * Helper method to get the Expense of a given type code.
     * This method iterates the collection of expenses and return 
     * the Expense of give type code or null if no expense for a given 
     * type code exists.
     * 
     * @param expenses
     * @param typeCode
     * @return Expense if found or null if no Expense with a given type found.
     */
    public static Expense getExpenseOfType(Collection expenses, ExpenseType.Code typeCode) {
		Validate.notNull(expenses, "The set of expenses must not be null");
		Validate.notNull(typeCode, "Expense type code must not be null");
        for (Iterator iter = expenses.iterator(); iter.hasNext();) {
            Expense expense = (Expense) iter.next();
            ExpenseType expenseType = expense.getType();
            if (expenseType != null 
                    && expenseType.getCode().equals(typeCode.getName())) {
                return expense;
            }
        }
        return null;
    }
}