/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.financials;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
//  Import third party library classes
//----------------------------------------------------------------------------
import java.math.BigDecimal;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Commons Team
 * @version 1.0
 */
public class DependentFinancials
    extends RelationFinancials {

    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID           = 5079500185003994240L;

    private Dependent         reportedOn                 = null;
    private Boolean           incapableOfSelfSupport     = null;
    private Boolean           contributedToSupport       = null;

    /**
     * Child has income is defined as an Indicator Yes/No the child had income
     * during last calendar year. Income payable to another person as guardian
     * or custodian of the child is considered to be the child's income.
     */
    private Boolean           hasIncome                  = null;
    /**
     * Dollar amount contributed to spousal or dependent support.
     */
    private BigDecimal        amountContributedToSupport = null;

    /**
     * Income available is defined, as an Indicator Yes/No the child's income
     * was available to the veteran. The child's income is deemed to be
     * available if it can be used to pay expenses of the veteran's household.
     * For example, a Social Security check payable to the veteran's estranged
     * spouse as custodian of the child was probable not available to the
     * veteran. On the other hand, a Social Security check on behalf of the
     * child payable to someone living in the veteran's household was probably
     * available.
     */
    private Boolean           incomeAvailableToPatient   = null;

    /**
     * Dependent child school indicator is defined as an indicator If the child
     * is between the ages of 18 and 23 indicate Yes/No if they attended school
     * last calendar year
     */
    private Boolean           attendedSchool             = null;

    /**
     * Creates a new DependentFinancials object.
     */
    public DependentFinancials() {
        super();
    }

    public DependentFinancials(Dependent dependent) {
        this();
        setReportedOn(dependent);
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------
    public Dependent getReportedOn() {
        return reportedOn;
    }

    public void setPerson(Person person) {
        super.setPerson(person);
        if (reportedOn != null) {
            reportedOn.setPerson(person);
        }
    }
    
    public void setReportedOn(Dependent reportedOn) {
        this.reportedOn = reportedOn;
        setRelationPerson(reportedOn);
    }

    public Boolean getIncapableOfSelfSupport() {
        return this.incapableOfSelfSupport;
    }

    public void setIncapableOfSelfSupport(Boolean incapableOfSelfSupport) {
        this.incapableOfSelfSupport = incapableOfSelfSupport;
    }

    public Boolean getContributedToSupport() {
        return this.contributedToSupport;
    }

    public void setContributedToSupport(Boolean contributedToSupport) {
        this.contributedToSupport = contributedToSupport;
    }

    public BigDecimal getAmountContributedToSupport() {
        return amountContributedToSupport;
    }

    public void setAmountContributedToSupport(
            BigDecimal amountContributedToSupport) {
        this.amountContributedToSupport = amountContributedToSupport;
    }

    public Boolean getHasIncome() {
        return this.hasIncome;
    }

    public void setHasIncome(Boolean hasIncome) {
        this.hasIncome = hasIncome;
    }

    public Boolean getIncomeAvailableToPatient() {
        return this.incomeAvailableToPatient;
    }

    public void setIncomeAvailableToPatient(Boolean incomeAvailableToPatient) {
        this.incomeAvailableToPatient = incomeAvailableToPatient;
    }

    public Boolean getAttendedSchool() {
        return this.attendedSchool;
    }

    public void setAttendedSchool(Boolean attendedSchool) {
        this.attendedSchool = attendedSchool;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("reportedOn", reportedOn);
        builder.append("incapableOfSelfSupport", this.incapableOfSelfSupport);
        builder.append("contributedToSupport", this.contributedToSupport);
        builder.append("amountContributedToSupport",
                this.amountContributedToSupport);
        builder.append("hasIncome", this.hasIncome);
        builder.append("incomeAvailableToPatient",
                this.incomeAvailableToPatient);
        builder.append("attendedSchool", this.attendedSchool);
    }
    
    protected Date getEndDate() { 
        return this.reportedOn != null ? this.reportedOn.getEndDate() : null;
    }    
}