/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

/*
 * Generated 12/9/2004 4:12:44 PM
 */ 

package gov.va.med.esr.common.model.financials;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import java.util.*;

//----------------------------------------------------------------------------
//  Import third party library classes
//----------------------------------------------------------------------------
import org.apache.commons.lang.builder.ToStringBuilder;

//----------------------------------------------------------------------------
//  Import Framework classes
//----------------------------------------------------------------------------
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

/**
 * 
 * @author Commons Team
 * @hibernate.class table="CONSENT"
 *  
 */

public class ConsentAuthorization extends AbstractKeyedEntity {

    //----------------------------------------------------------------------------
    // Static variable(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Static method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Constructor(s)
    //----------------------------------------------------------------------------

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8404417371686628861L;

	/**
     * Creates a new ConsentAuthorization object.
     */
    public ConsentAuthorization() {
        this(null);
    }
    
    public ConsentAuthorization(Person person) {
        super();
        setPerson(person);
    }
    
    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    /**
     * Get the Code attribute
     * 
     * @return The Code instance variable.
     * 
     * @hibernate.property column="AUTHORIZED_CODE"
     */
    public java.math.BigDecimal getCode() {
        return (code);
    }

    /**
     * Get the ImageIndexNum attribute
     * 
     * @return The ImageIndexNum instance variable.
     * 
     * @hibernate.property column="IMAGE_INDEX_NUMBER"
     */
    public Integer getImageIndexNum() {
        return (imageIndexNum);
    }

    /**
     * Get the LastUpdatedBy attribute
     * 
     * @return The LastUpdatedBy instance variable.
     * 
     * @hibernate.property column="UPDATED_BY"
     */
    public java.math.BigDecimal getLastUpdatedBy() {
        return (lastUpdatedBy);
    }

    /**
     * Get the LastUpdatedDate attribute
     * 
     * @return The LastUpdatedDate instance variable.
     * 
     * @hibernate.property column="UPDATED_DATE"
     */
    public Date getLastUpdatedDate() {
        return getModifiedOn();

    }

    /**
     * Get the SiteSubmittingImage attribute
     * 
     * @return The SiteSubmittingImage instance variable.
     * 
     * @hibernate.many-to-one column="CONSENT_IMAGING_SITE_ID"
     *                        class="gov.va.med.esr.common.model.party.VAFacility"
     *                        cascade="all"
     */
    public VAFacility getSiteSubmittingImage() {
        return (siteSubmittingImage);
    }

    /**
     * @return Returns the person.
     */
    public Person getPerson() {
        return person;
    }

    /**
     * Set the Code attribute
     * 
     * @param newCode
     *            The value to set the Code instance variable to.
     */
    public void setCode(java.math.BigDecimal newCode) {
        code = newCode;
    }

    /**
     * Set the ImageIndexNum attribute
     * 
     * @param newImageIndexNum
     *            The value to set the ImageIndexNum instance variable to.
     */
    public void setImageIndexNum(Integer newImageIndexNum) {
        imageIndexNum = newImageIndexNum;
    }

    /**
     * Set the LastUpdatedBy attribute
     * 
     * @param newLastUpdatedBy
     *            The value to set the LastUpdatedBy instance variable to.
     */
    public void setLastUpdatedBy(java.math.BigDecimal newLastUpdatedBy) {
        lastUpdatedBy = newLastUpdatedBy;
    }

    /**
     * Set the LastUpdatedDate attribute
     * 
     * @param newLastUpdatedDate
     *            The value to set the LastUpdatedDate instance variable to.
     */
    /*public void setLastUpdatedDate(Date newLastUpdatedDate) {
        lastUpdatedDate = newLastUpdatedDate;
    }*/

    /**
     * Set the SiteSubmittingImage attribute
     * 
     * @param newSiteSubmittingImage
     *            The value to set the SiteSubmittingImage instance variable to.
     */
    public void setSiteSubmittingImage(VAFacility newSiteSubmittingImage) {
        siteSubmittingImage = newSiteSubmittingImage;
    }

    /**
     * @param person The person to set.
     */
    public void setPerson(Person person) {
        this.person = person;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);

        builder.append("code", this.code);
        builder.append("imageIndexNum", this.imageIndexNum);
        builder.append("lastUpdatedBy", this.lastUpdatedBy);
        builder.append("lastUpdatedDate", this.getLastUpdatedDate());
        //builder.append("siteSubmittingImage", this.siteSubmittingImage);
    }

    //----------------------------------------------------------------------------
    // Package protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Private method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // All attributes that are not static
    //----------------------------------------------------------------------------

    /**
     * Consent/Authorization Code is defined as a code to indicate whether a
     * financial test for the income year has been imaged and if the imaged
     * document contains the veteran's signature.
     * 
     * Choices are: 1=Yes, a signed document ahs been imaged with a valid
     * signature, 0=No, a signed document has been imaged without a valid
     * signature, 9=Deleted, previous 1/0 has been deleted by direct edit user,
     * NULL=a Means test document has not been imaged.
     */
    private java.math.BigDecimal code = null;

    /**
     * Consent/Authorization Image Index Number is defined as the unique image
     * index number associated with the Means Test that is assigned by the
     * imaging system.The number must be a positive integer value.
     */
    private Integer imageIndexNum = null;

    /**
     * Person Last Updating Consent/Authorization is defined as the person who
     * imaged the document in the imaging system or performed a direct edit to
     * the information.
     */
    private java.math.BigDecimal lastUpdatedBy = null;

    /**
     * Date Consent/Authorization Last Updated is defined as the date on which
     * the Consent/Authorization Code was last updated .
     */
    //private Date lastUpdatedDate = null;

    /**
     * Site Submitting Image is defined as the site that submitted the image to
     * HEC.
     */
    private VAFacility siteSubmittingImage = null;

    private Person person = null;

} //  End of ConsentAuthorization Class

