/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.financials;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import java.math.BigDecimal;
import java.util.Date;

//----------------------------------------------------------------------------
//  Import third party library classes
//----------------------------------------------------------------------------
import org.apache.commons.lang.builder.ToStringBuilder;

//----------------------------------------------------------------------------
//  Import Framework classes
//----------------------------------------------------------------------------
import gov.va.med.esr.common.model.SiteYear;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * 
 * @author Commons Team
 * @version 1.0
 */
public class BeneficiaryTravel
    extends AbstractKeyedEntity {
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = -1788227203856018919L;

    /**
     * Date Certified is defined as the date of annual income certification used
     * in the Beneficial Travel Claim process. 
     */
    private Date              dateCertified    = null;

    /**
     * Amount Certified is defined as the patient's annual income for the
     * previous year as reported by the patient. If the veteran is required to
     * do a beneficiary travel test this number will be compared to the VA
     * Pension threshold based on # of dependents. This comparison is a manual
     * comparison done on VISTA by the travel clerk.
     */
    private BigDecimal        amountCertified  = null;

    private Date              claimDate        = null;

    /**
     * Eligible Indicator is defined as a code to indicate if this person is
     * required to perform a Beneficiary Travel test to receive benefits. 
     */
    private Boolean           eligible         = null;

    private VAFacility        facilityVisited  = null;
    private Integer           year             = null;
    private SiteYear          siteYear         = null;

    private Person            person           = null;

    /**
     * Creates a new BeneficiaryTravel object.
     */
    public BeneficiaryTravel() {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    public Person getPerson() {
        return person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person, person);
        this.person = person;
    }

    private SiteYear getSiteYear() {
        return siteYear;
    }

    private void setSiteYear(SiteYear siteYear) {
        this.siteYear = siteYear;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Date getDateCertified() {
        return this.dateCertified;
    }

    public void setDateCertified(Date dateCertified) {
        this.dateCertified = dateCertified;
    }

    public BigDecimal getAmountCertified() {
        return this.amountCertified;
    }

    public void setAmountCertified(BigDecimal amountCertified) {
        this.amountCertified = amountCertified;
    }

    public Date getClaimDate() {
        return this.claimDate;
    }

    public void setClaimDate(Date claimDate) {
        this.claimDate = claimDate;
    }

    public Boolean isEligible() {
        return this.eligible;
    }

    public Boolean getEligible() {
        return isEligible();
    }

    public void setEligible(Boolean eligible) {
        this.eligible = eligible;
    }

    public VAFacility getFacilityVisited() {
        return this.facilityVisited;
    }

    public void setFacilityVisited(VAFacility facilityVisited) {
        this.facilityVisited = facilityVisited;
    }

    /*
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("year", this.year);
        builder.append("dateCertified", this.dateCertified);
        builder.append("amountCertified", this.amountCertified);
        builder.append("claimDate", this.claimDate);
        builder.append("eligible", this.eligible);
        builder.append("facilityVisited", this.facilityVisited);
    }
}