/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.financials;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import gov.va.med.esr.common.model.lookup.AssetType;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 
 * @author Commons Team
 * @author DNS   mansog
 * @version 1.0
 */
public class Asset
    extends Financial {
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = -4926096977860253675L;

    private AssetType         type             = null;

    /**
     * Creates a new Asset object.
     */
    public Asset() {
        super();
    }

    public Asset(BigDecimal amount) {
        super(amount);
    }
    
    public AssetType getType() {
        return this.type;
    }

    protected void setType(AssetType type) {
        this.type = type;
    }

    /**
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("type", this.type);
    }

    /**
     * Helper method to get the Asset of a given type code.
     * This method iterates the collection of assets and return 
     * the Asset of give type code or null if no asset for a given 
     * type code exists.
     * 
     * @param assets
     * @param typeCode
     * @return Asset if found or null if no Asset with a given type found.
     */
    public static Asset getAssetOfType(Collection assets, AssetType.Code typeCode) {
		Validate.notNull(assets, "The set of assets must not be null");
		Validate.notNull(typeCode, "Asset type code must not be null");
        for (Iterator iter = assets.iterator(); iter.hasNext();) {
            Asset asset = (Asset) iter.next();
            AssetType assetType = asset.getType();
            if (assetType != null 
                    && assetType.getCode().equals(typeCode.getName())) {
                return asset;
            }
        }
        return null;
    }
}