package gov.va.med.esr.common.model.ee;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang.Validate;


import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.VOAApplication;
/**
 * @author Commons Team
 * @author DNS   TSAIG
 * @version 1.0
 */
public class VoaFileAttachment extends AbstractKeyedEntity {

	/**
	 * 
	 */
	private static final long serialVersionUID = -9181352550740099727L;
	/**
	 * An instance of serialVersionUID
	 */
	
	private BigDecimal personId = null;
	private String fileName = null;
	private String fileMimeType = null;
	
	private Boolean attchmentAcceptableInd = null;
	private Date attachmentReviewDate = null;
	private String attachmentReviewUserName = null;
	
	private Set internalAttachmentDetails = new HashSet();
	
	private Set internalAttachmentImages = new HashSet();

	private VOAApplication voaApplication = null;

	public VoaFileAttachment() {
		super();
	}
	
	public Date getAttachmentReviewDate() {
		return attachmentReviewDate;
	}
	public void setAttachmentReviewDate(Date attachmentReviewDate) {
		this.attachmentReviewDate = attachmentReviewDate;
	}
	public String getAttachmentReviewUserName() {
		return attachmentReviewUserName;
	}
	public void setAttachmentReviewUserName(String attachmentReviewUserName) {
		this.attachmentReviewUserName = attachmentReviewUserName;
	}
	public Boolean getAttchmentAcceptableInd() {
		return attchmentAcceptableInd;
	}
	public void setAttchmentAcceptableInd(Boolean attchmentAcceptableInd) {
		this.attchmentAcceptableInd = attchmentAcceptableInd;
	}

	public String getFileName() {
		return fileName;
	}
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}
	public String getFileMimeType() {
		return fileMimeType;
	}
	public void setFileMimeType(String fileMimeType) {
		this.fileMimeType = fileMimeType;
	}

	public BigDecimal getPersonId() {
		return personId;
	}
	public void setPersonId(BigDecimal personId) {
		this.personId = personId;
	}

	/**
	* Returns a collection of AttachmentDetail Objects.
	* 
	* @return Set - Set if AttachmentDetail
	*/
	public Set getAttachmentDetailLst() {
      return this.getInternalAttachmentDetails();
	}

	/**
	* Getter - for hibernate use only.
	* 
	* @return
	*/
   private Set getInternalAttachmentDetails() {
      if( this.internalAttachmentDetails == null ) {
         this.internalAttachmentDetails = new HashSet();
      }
      return this.internalAttachmentDetails;
   }
	
	/**
	* Setter - for hibernate use only.
	* 
	* @param internalAttachmentDetails
	*/
   private void setInternalAttachmentDetails(Set internalAttachmentDetails) {
      this.internalAttachmentDetails = internalAttachmentDetails;
   }

   public void addVoaAttachmentDetail(VoaFileAttachmentDetail attachment) {
		Validate.notNull(attachment, "Null attachment specified.");
		getInternalAttachmentDetails().add(attachment);
		attachment.setVoaFileAttachment(this);
	}

	public void removeAllVoaAttachmentDetails() {
		Iterator it = getInternalAttachmentDetails().iterator();
		//null out reference to parent
		while (it.hasNext())
		{
			((VoaFileAttachmentDetail)it.next()).setVoaFileAttachment(null);
		}
		getInternalAttachmentDetails().clear();
	}

	/**
	* Getter - for hibernate use only.
	* 
	* @return
	*/
   private Set getInternalAttachmentImages() {
      if( this.internalAttachmentImages == null ) {
         this.internalAttachmentImages = new HashSet();
      }
      return this.internalAttachmentImages;
   }
	
	/**
	* Setter - for hibernate use only.
	* 
	* @param internalAttachmentImages
	*/
   private void setInternalAttachmentImages(Set internalAttachmentImages) {
      this.internalAttachmentImages = internalAttachmentImages;
   }

   public VoaFileAttachmentImage getAttachmentImage() {
      Set attachmentImages = getInternalAttachmentImages();
      return (VoaFileAttachmentImage)attachmentImages.iterator().next();
   }

   public void setAttachmentImage(VoaFileAttachmentImage attachmentImage) {
      Set attachmentImages = getInternalAttachmentImages();
      attachmentImages.clear();
      if( attachmentImage != null ) {
    	  attachmentImages.add(attachmentImage);
    	  attachmentImage.setVoaFileAttachment(this);
      }
   }
   
	public VOAApplication getVoaApplication() {
		return voaApplication;
	}

	public void setVoaApplication(VOAApplication voaApplication) {
        validateOwner(this.voaApplication, voaApplication);
		this.voaApplication = voaApplication;
	}

}