/*****************************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.esr.common.model.ee;

// Java classes
import java.util.List;
import java.util.Collection;
import java.util.ArrayList;
import java.util.Collections;


import org.apache.commons.lang.builder.ToStringBuilder;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.esr.common.model.workload.WorkflowCaseInfo;
import gov.va.med.esr.common.infra.ImpreciseDate;

/**
 * This objects contains data from the special ZEL segment that comes from VBA. This
 * object is not part of our EDB object model.
 * 
 * @author Vu Le
 */
public class VerificationInfo extends AbstractEntity {

   /**
    * An instance of serialVersionUID
    */
   private static final long serialVersionUID = 1613147296614831932L;

   private String entitlementCode = null;

   private String messageType = null;

   private String dfn = null;

   private String textMessage = null;

   private List exceptions = null;

   private Integer combinedSCPercentage = null;

   private boolean triggerEnrollmentProcess = false;
   
   private boolean hasQualifyingMse = false;   

   private String unsolicitedType = null;

   private WorkflowCaseInfo workflowCaseInfo = null;

   private String siteNumber = null;
   
   private String messageControlId = null;
   
   private ImpreciseDate msdsMessageDate = null;
   
   //CCR11898
   private boolean tempAddressUpdateMoreRecent = false;
   
   
   public VerificationInfo() {
      this(null,null);
   }

   public VerificationInfo( String messageType, String errorText ) {
      this(null,messageType,errorText);
   }
   
   public VerificationInfo(String entitlementCode, String messageType, String errorText) {
      this(entitlementCode, messageType, errorText, null);
   }

   /**
    * An entitlement data with the specific code, and a business context
    */
   public VerificationInfo(String entitlementCode, String messageType, String errorText, Integer percentage) {
      super();
      this.entitlementCode = entitlementCode;
      this.messageType = messageType;
      this.textMessage = errorText;
      this.combinedSCPercentage = percentage;
      this.exceptions = Collections.synchronizedList(new ArrayList());
   }

   /**
    * Returns an entitlement code
    * 
    * @return An entitlement code
    */
   public String getEntitlementCode() {
      return entitlementCode;
   }

   /**
    * Returns a business context
    * 
    * @return A business context
    */
   public String getMessageType() {
      return messageType;
   }

   /**
    * Returns a text message
    * 
    * @return A text message
    */
   public String getTextMessage() {
      return textMessage;
   }

   /**
    * Adds an exception that was thrown during a process of building an entity from a
    * message
    * 
    * @param e
    */
   public void addException(Exception e) {
      if( e != null && !exceptions.contains(e) ) {
         exceptions.add(e);
      }
   }

   /**
    * Removes an exception that was thrown during a process of building an entity from a
    * message
    * 
    * @param e
    *           A user exception
    */
   public void removeException(Exception e) {
      if( e != null && exceptions.contains(e) ) {
         exceptions.remove(e);
      }
   }

   /**
    * Clears all exceptions
    */
   public void clearExceptions() {
      exceptions.clear();
   }

   /**
    * Adds all exceptions generated during the message processing
    * 
    * @param input
    *           A list of exceptions
    */
   public void addExceptions(Collection list) {
      if( list != null ) {
         exceptions.addAll(list);
      }
   }

   public List getExceptions() {
      return this.exceptions;
   }

   /**
    * @return Returns the combinedSCPercentage.
    */
   public Integer getCombinedSCPercentage() {
      return combinedSCPercentage;
   }

   /**
    * @param combinedSCPercentage
    *           The combinedSCPercentage to set.
    */
   public void setCombinedSCPercentage(Integer combinedSCPercentage) {
      this.combinedSCPercentage = combinedSCPercentage;
   }

   /**
    * @return Returns the dfn.
    */
   public String getDfn() {
      return dfn;
   }

   /**
    * @param dfn
    *           The dfn to set.
    */
   public void setDfn(String dfn) {
      this.dfn = dfn;
   }

   /**
    * @return Returns the triggerEnrollmentProcess.
    */
   public boolean isTriggerEnrollmentProcess() {
      return triggerEnrollmentProcess;
   }

   /**
    * @param triggerEnrollmentProcess
    *           The triggerEnrollmentProcess to set.
    */
   public void setTriggerEnrollmentProcess(boolean triggerEnrollmentProcess) {
      this.triggerEnrollmentProcess = triggerEnrollmentProcess;
   }

   /**
    * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
    */
   protected void buildToString(ToStringBuilder builder) {
      builder.append("context", this.messageType);
      builder.append("code", this.entitlementCode);
      builder.append("message", this.textMessage);
   }

   /**
    * @return Returns the WorkflowCaseInfo.
    */
   public WorkflowCaseInfo getWorkflowCaseInfo() {
      return workflowCaseInfo;
   }

   /**
    * @param messageCaseInfo
    *           The messageCaseInfo to set.
    */
   public void setWorkflowCaseInfo(WorkflowCaseInfo workflowCaseInfo) {
      this.workflowCaseInfo = workflowCaseInfo;
   }

   /**
    * Returns an instance of unsolicitedType
    * @return String unsolicitedType.
    */
   public String getUnsolicitedType() {
      return unsolicitedType;
   }

   /**
    * Sets the unsolicitedType of type String
    * @param unsolicitedType The unsolicitedType to set.
    */
   public void setUnsolicitedType(String unsolicitedType) {
      this.unsolicitedType = unsolicitedType;
   }

   /**
    * Returns an instance of siteNumber
    * @return String siteNumber.
    */
   public String getSiteNumber() {
      return siteNumber;
   }

   /**
    * Sets the siteNumber of type String
    * @param siteNumber The siteNumber to set.
    */
   public void setSiteNumber(String siteNumber) {
      this.siteNumber = siteNumber;
   }

	public String getMessageControlId() {
		return messageControlId;
	}
	
	public void setMessageControlId(String messageControlId) {
		this.messageControlId = messageControlId;
	}

	public boolean hasQualifyingMse() {
		return hasQualifyingMse;
	}

	public void setHasQualifyingMse(boolean hasQualifyingMse) {
		this.hasQualifyingMse = hasQualifyingMse;
	}

	public ImpreciseDate getMsdsMessageDate() {
		return msdsMessageDate;
	}

	public void setMsdsMessageDate(ImpreciseDate msdsMessageDate) {
		this.msdsMessageDate = msdsMessageDate;
	}
    //CCR11898
	public boolean isTempAddressUpdateMoreRecent() {
		return tempAddressUpdateMoreRecent;
	}

	public void setTempAddressUpdateMoreRecent(boolean tempAddressUpdateMoreRecent) {
		this.tempAddressUpdateMoreRecent = tempAddressUpdateMoreRecent;
	}

	
}