/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.ee;

// Java classes

// Library classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework classes
import gov.va.med.fw.model.AbstractKeyedEntity;

// ESR classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.lookup.VceStatusType;

/**
 * This is one of the classes of the Business Object Model (BOM).
 * This class represents a Veterans Choice Eligibility.
 *
 * @author Sridhar Rao
 * @version 3.0
 */
public class VcEligibility extends AbstractKeyedEntity {
	private static final long serialVersionUID = -8788971651792648011L;

	private Person person;
	private VceStatusType vceStatusType;

	/**
     * Default Constructor.
     */
    public VcEligibility() {
        super();
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person,person);
        this.person = person;
    }

    public VceStatusType getVceStatusType() {
		return vceStatusType;
	}

	public void setVceStatusType(VceStatusType vceStatusType) {
		this.vceStatusType = vceStatusType;
	}

    /**
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("person", this.person);
        builder.append("vceStatusType", this.vceStatusType);
    }

}
