/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.ee;

// Java classes

// Library classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework classes
import gov.va.med.fw.model.AbstractKeyedEntity;

// ESR classes
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.lookup.Indicator;

/**
 * This is one of the classes of the Business Object Model (BOM).
 * This class represents a generic special factor.
 * Specific sub-classes extend this class and define the specific special factors.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public abstract class SpecialFactor extends AbstractKeyedEntity
{
    private static final long serialVersionUID = -1370346746640850300L;
    private Person person = null;
    private ImpreciseDate registrationDate = null;
    private ImpreciseDate examinationDate = null;
    private Integer registrationNumber = null;
    private String remarks = null;
    protected Indicator specialFactorIndicator = null;

    /**
     * Default Constructor.
     */
    public SpecialFactor()
    {
        super();
    }

    public Person getPerson()
    {
        return this.person;
    }

    public void setPerson(Person person)
    {
        this.validateOwner(this.person,person);
        this.person = person;
    }

    public ImpreciseDate getExaminationDate()
    {
        return (examinationDate);
    }

    public void setExaminationDate(ImpreciseDate examinationDate)
    {
        this.examinationDate = examinationDate;
    }

    public ImpreciseDate getRegistrationDate()
    {
        return (registrationDate);
    }

    public void setRegistrationDate(ImpreciseDate registrationDate)
    {
        this.registrationDate = registrationDate;
    }

    public Integer getRegistrationNumber()
    {
        return (registrationNumber);
    }

    public void setRegistrationNumber(Integer registrationNumber)
    {
        this.registrationNumber = registrationNumber;
    }

    public String getRemarks()
    {
        return remarks;
    }

    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

	/**
	 * @return Returns the specialFactorIndicator.
	 */
	public Indicator getSpecialFactorIndicator() {
		return specialFactorIndicator;
	}
	/**
	 * @param specialFactorIndicator The specialFactorIndicator to set.
	 */
	public void setSpecialFactorIndicator(Indicator specialFactorIndicator) {
		this.specialFactorIndicator = specialFactorIndicator;
	}
    /**
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);
        builder.append("registrationDate", this.registrationDate);
        builder.append("examinationDate", this.examinationDate);
        builder.append("registrationNumber", this.registrationNumber);
        builder.append("remarks", this.remarks);
    }
    

}
