/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.ee;

// Java classes
import java.util.Date;

// Libraries
import org.apache.commons.lang.builder.ToStringBuilder;

// ESR classes
import gov.va.med.esr.common.model.lookup.SHADDocumentType;
import gov.va.med.esr.common.model.ee.SHAD;

/**
 * 
 * @author Muddaiah ranga
 * @version 3.0
 */
public class SHADDocument extends Document {
	
	private static final long serialVersionUID = -4457957494390182672L;

    private SHAD shad = null;
    
    private SHADDocumentType documentType = null;
	private Date receivedDate = null;

    public SHADDocument()
    {
        super();
    }

    // ----------------------------------------------------------------------------
    // Public method(s)
    // ----------------------------------------------------------------------------
    
    public SHAD getShad() {
        return shad;
    }

    public void setShad(SHAD shad) {
        this.validateOwner(this.shad, shad);
        this.shad = shad;
    }

    public SHADDocumentType getDocumentType() {
        return documentType;
    }

    public void setDocumentType(SHADDocumentType documentType) {
        this.documentType = documentType;
    }
    
    public Date getReceivedDate() {
        return receivedDate;
    }

    public void setReceivedDate(Date receivedDate) {
        this.receivedDate = receivedDate;
    }

	/*
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder
            .append("documentType", this.documentType)
            .append("receivedDate", this.receivedDate)
        );
    }
} // End of SHADDocument Class
