/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.ee;

// Java classes

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

// ESR classes
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.fw.model.EntityKey;

/**
 * 
 * @author Muddaiah Ranga
 * @version 1.0
 */
public class SHAD extends Registry {
    
    private static final long serialVersionUID = 8067965625445127187L;

    private Indicator shadIndicator = null;
    private String claimNumber;
    private Set internalDocuments = null;

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------
    
    public Indicator getShadIndicator() {
        return shadIndicator;
    }

    public void setShadIndicator(Indicator shadIndicator) {
        this.shadIndicator = shadIndicator;
    }
    
    public String getClaimNumber() {
        return claimNumber;
    }

    public void setClaimNumber(String claimNumber) {
        this.claimNumber = claimNumber;
    }

    public Set getDocuments() {
        return Collections.unmodifiableSet(getInternalDocuments());
    }

    public void addDocument(SHADDocument document) {
        Validate.notNull(document, "document cannot be null");
        getInternalDocuments().add(document);
        document.setShad(this);
    }

    public void addAllDocuments(Set documents) {
        Validate.notEmpty(documents, "SHAD documents cannot be null or empty");
        
        // Call addDocument to handle bidirectional relationship
        for (Iterator i = documents.iterator(); i.hasNext();) {
            Object document = i.next();
            if (document instanceof SHADDocument) {
                this.addDocument((SHADDocument)document);
            }
        }
    }
    
    public void removeDocument(SHADDocument document) {
        Validate.notNull(document, "Document cannot be null");
        getInternalDocuments().remove(document);
        document.setShad(null);
    }
    
    public SHADDocument getDocumentByEntityKey(EntityKey identifier) {
        return (SHADDocument) getEntityByEntityKey(getDocuments(),identifier);
    }

    public SHADDocument removeDocumentByEntityKey(EntityKey identifier) {
        return (SHADDocument) removeEntityByEntityKey(getInternalDocuments(),identifier);
    }

    public void removeAllDocuments() {
        getInternalDocuments().clear();
    }
    
    private Set getInternalDocuments() {
        if (internalDocuments == null) {
            this.internalDocuments = new HashSet();
        }
        return this.internalDocuments;
    }

    private void setInternalDocuments(Set internalDocuments) {
        this.internalDocuments = internalDocuments;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder
            .append("shadIndicator",this.shadIndicator)
            .append("claimNumber",this.claimNumber)
        );
    }
}