/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.ee;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.AlliedCountry;
import gov.va.med.esr.common.model.lookup.FederalAgency;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Commons Team
 * @author DNS   MANSOG
 * @version 1.0
 */
public class ReceivedEligibility extends AbstractKeyedEntity {
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 476461315809053822L;
	private static final String PRIMARY_IND   = "P";
    private static final String SECONDARY_IND = "S";

    private Person              person;
    private EligibilityType     type          = null;
    private AlliedCountry		alliedCountry = null;
    private FederalAgency		otherFederalAgency	= null;
    private String              indicator     = null;

    private VAFacility          reportSite    = null;
    
    private boolean voaHasAttachment = false;

    /**
     * Creates a new Eligibility object.
     */
    public ReceivedEligibility() {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------
    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person,person);        
        this.person = person;
    }

    public EligibilityType getType() {
        return this.type;
    }

    public void setType(EligibilityType type) {
        this.type = type;
    }
    
    public void setAlliedCountry(AlliedCountry country) {
        this.alliedCountry = country;
    }
    
    public AlliedCountry getAlliedCountry() {
        return this.alliedCountry;
    }

    public void setOtherFederalAgency(FederalAgency otherFederalAgency) {
        this.otherFederalAgency = otherFederalAgency;
    }
    
    public FederalAgency getOtherFederalAgency() {
        return this.otherFederalAgency;
    }

   public VAFacility getReportSite() {
        return this.reportSite;
    }

    public void setReportSite(VAFacility reportSite) {
        this.reportSite = reportSite;
    }

    private String getIndicator() {
        return this.indicator;
    }

    private void setIndicator(String indicator) {
        this.indicator = indicator;
    }

    public boolean  isVoaHasAttachment()
    {
    	return voaHasAttachment;
    }
    
    public void setVoaHasAttachment(boolean voaHasAttachment)
    {
    	this.voaHasAttachment = voaHasAttachment;
    }
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("type", this.type);
        builder.append("indicator", this.indicator);
    }


    public void setPrimary() {
        setIndicator(PRIMARY_IND);
    }

    public void setSecondary() {
    	setIndicator(SECONDARY_IND);
    }

}