package gov.va.med.esr.common.model.ee;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.DiagnosticExtremity;
import gov.va.med.esr.common.model.lookup.Disability;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.lookup.ModelPropertiesApplicationType;

/**
 * @author Commons Team
 * @author DNS   MANSOG
 * @version 1.0
 */
public class RatedDisability extends AbstractKeyedEntity {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -9181352550740099727L;

	private ServiceConnectionAward serviceConnectionAward;

	private Disability disability = null;

	private Integer percentage = null;

	private Boolean serviceConnected = null;

	private DiagnosticExtremity diagnosticExtremity = null;

	private ImpreciseDate originalEffectiveRatingDate;

	private ImpreciseDate ratingDate;

	/**
	 * Creates a new RatedDisability object.
	 */
	public RatedDisability() {
		super();
	}

	public ServiceConnectionAward getServiceConnectionAward() {
		return this.serviceConnectionAward;
	}

	public void setServiceConnectionAward(
			ServiceConnectionAward serviceConnectionAward) {
		this.serviceConnectionAward = serviceConnectionAward;
	}

	public Disability getDisability() {
		return this.disability;
	}

	public void setDisability(Disability disability) {
		this.disability = disability;
	}

	public Integer getPercentage() {
		return this.percentage;
	}

	public void setPercentage(Integer percentage) {
		this.percentage = percentage;
	}

	public Boolean isServiceConnected() {
		return this.serviceConnected;
	}

	public void setServiceConnected(Boolean serviceConnected) {
		this.serviceConnected = serviceConnected;
	}

	public DiagnosticExtremity getDiagnosticExtremity() {
		return this.diagnosticExtremity;
	}

	public void setDiagnosticExtremity(DiagnosticExtremity diagnosticExtremity) {
		this.diagnosticExtremity = diagnosticExtremity;
	}

	public ImpreciseDate getRatingDate() {
		return this.ratingDate;
	}

	public void setRatingDate(ImpreciseDate date) {
		this.ratingDate = date;
	}

	public ImpreciseDate getOriginalEffectiveRatingDate() {
		return this.originalEffectiveRatingDate;
	}

	public void setOriginalEffectiveRatingDate(ImpreciseDate date) {
		this.originalEffectiveRatingDate = date;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("disability", this.disability);
		builder.append("percentage", this.percentage);
		builder.append("serviceConnected", this.serviceConnected);
	}

	/** Since requirements dictate that there can be more than one RatedDisability with identical information,
	 * we must ensure that Set operations allow this.  Approach taken here is to ensure they do not equal 
	 * (even if have identical data). */
	protected OrderedMap getPropertyValueMapForIdentity() {
		OrderedMap map = new ListOrderedMap();
		// two different objects (regardless of content) will not equal (if they do not have same identifier)!
		if(getIdentifier() == null)
			map.put("identifier", new Integer(System.identityHashCode(this)));
		else
			map.put("identifier", getIdentifier());
		return map;
	}
}