/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/

package gov.va.med.esr.common.model.ee;

// Java classes

// Library classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.lookup.RadiationExposureMethod;
import gov.va.med.esr.common.model.lookup.Indicator;

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents a Radiation Exposure special factor.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class RadiationExposure extends SpecialFactor {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 7443543983198419908L;

	private RadiationExposureMethod exposureMethod = null;

	/**
	 * Default Constructor.
	 */
	public RadiationExposure() {
		super();
	}

	public RadiationExposureMethod getExposureMethod() {
		return this.exposureMethod;
	}

	public void setExposureMethod(RadiationExposureMethod exposureMethod) {
		this.exposureMethod = exposureMethod;
	}

    public Indicator getRadiationExposureIndicator() {
        return specialFactorIndicator;
    }

    public void setRadiationExposureIndicator(Indicator radiationExposureIndicator) {
        this.specialFactorIndicator = radiationExposureIndicator;
    }



	/**
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("exposureMethod", this.exposureMethod);
        builder.append("radiationExposureIndicator",this.specialFactorIndicator);

	}
}