/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.ee;

// Java classes
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.lookup.PHDataSource;
import gov.va.med.esr.common.model.lookup.PHDocumentType;

/**
 * 
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.subclass discriminator-value="02"
 * 
 */
public class PurpleHeartDocument extends Document implements Comparable{
	
	private static final long serialVersionUID = -4457957494390182672L;

    private PurpleHeart purpleHeart = null;
    
    private PHDocumentType documentType = null;
    private PHDataSource dataSource = null;
	private Date receivedDate = null;
    private Date loginDate = null;
    private String loggedInUser = null;
    private Boolean acceptable = null;
    private String unacceptableRemarks = null;

    public PurpleHeartDocument()
    {
        super();
    }

    // ----------------------------------------------------------------------------
    // Public method(s)
    // ----------------------------------------------------------------------------
    
    public PurpleHeart getPurpleHeart() {
        return purpleHeart;
    }
    
    public void setPurpleHeart(PurpleHeart purpleHeart) {
        this.validateOwner(this.purpleHeart, purpleHeart);
        this.purpleHeart = purpleHeart;
    }

    public PHDocumentType getDocumentType() {
        return documentType;
    }

    public void setDocumentType(PHDocumentType documentType) {
        this.documentType = documentType;
    }
    
    public PHDataSource getDataSource() {
        return dataSource;
    }

    public void setDataSource(PHDataSource dataSource) {
        this.dataSource = dataSource;
    }
    
    public Date getReceivedDate() {
        return receivedDate;
    }

    public void setReceivedDate(Date receivedDate) {
        this.receivedDate = receivedDate;
    }

    public Date getLoginDate() {
        return loginDate;
    }

    public void setLoginDate(Date loginDate) {
        this.loginDate = loginDate;
    }

	public String getLoggedInUser() {
		return loggedInUser;
	}

	public void setLoggedInUser(String loggedInUser) {
		this.loggedInUser = loggedInUser;
	}
    
    public Boolean getAcceptable() {
        return acceptable;
    }

    public void setAcceptable(Boolean acceptable) {
        this.acceptable = acceptable;
    }

	public String getUnacceptableRemarks() {
		return unacceptableRemarks;
	}

	public void setUnacceptableRemarks(String unacceptableRemarks) {
		this.unacceptableRemarks = unacceptableRemarks;
	}

	/*
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder
            .append("documentType", this.documentType)
            .append("dataSource", this.dataSource)
            .append("receivedDate", this.receivedDate)
            .append("loginDate", this.loginDate)
            .append("loggedInUser", this.loggedInUser)
            .append("acceptable", this.acceptable)
            .append("unacceptableRemarks", this.unacceptableRemarks)
        );
    }

    public int compareTo(Object o) {
        if (o != null && o instanceof PurpleHeartDocument) {
            PurpleHeartDocument t = (PurpleHeartDocument) o;
            return compareDates(getReceivedDate(),t.getReceivedDate());
        }
        return 1;
    }
    
    private int compareDates(Date date1, Date date2) {
        if (date1 != null && date2 != null) {
            return date1.compareTo(date2); 
        }
        else {
            return date1 == null ? -1 : 1;
        }
    }
} // End of PurpleHeartDocument Class
