/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.ee;

// Java classes
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

// ESR classes
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.RejectionRemark;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.fw.model.EntityKey;

/**
 * 
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.subclass discriminator-value="02"
 *  
 */
public class PurpleHeart extends Registry implements Decoration {
	
	private static final long serialVersionUID = -4457957494390182672L;
	
    private Boolean phIndicator = null;
    
	private RejectionRemark rejectionRemark = null;
	
    private VAFacility facility = null;
    
    private DecorationStatus status = null;
    private Date statusLastEditDate = null;
    private String statusLastUpdateUser = null;
    private String assignedContactUser = null;
    
	private Set internalDocuments = null;

    
    public PurpleHeart()
    {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------
    
    public void setPhIndicator(Boolean indicator)
    {
        this.phIndicator = indicator;
    }
    
    public Boolean getPhIndicator()
    {
        return this.phIndicator;
    }
    
    public RejectionRemark getRejectionRemark()
    {
        return this.rejectionRemark;
    }

    public void setRejectionRemark(RejectionRemark rejectionRemark)
    {
        this.rejectionRemark = rejectionRemark;
    }
    
    public VAFacility getFacility() {
        return this.facility;
    }
    
    public void setFacility(VAFacility facility) {
        this.facility = facility;
    }

    public DecorationStatus getStatus() {
        return this.status;
    }

    public void setStatus(DecorationStatus status) {
        this.status = status;
    }

    public Date getStatusLastEditDate() {
        return statusLastEditDate;
    }

    public void setStatusLastEditDate(Date statusLastEditDate) {
        this.statusLastEditDate = statusLastEditDate;
    }

    public String getStatusLastUpdateUser() {
        return statusLastUpdateUser;
    }

    public void setStatusLastUpdateUser(String statusLastUpdateUser) {
        this.statusLastUpdateUser = statusLastUpdateUser;
    }
    
    public String getAssignedContactUser() {
        return assignedContactUser;
    }

    public void setAssignedContactUser(String assignedContactUser) {
        this.assignedContactUser = assignedContactUser;
    }
    
	public Set getDocuments() {
		return Collections.unmodifiableSet(getInternalDocuments());
	}
	/**
     * Added new methods with standard class name for person merge
     * @param document
	 */
    public void addPurpleHeartDocument(PurpleHeartDocument document) {
        Validate.notNull(document, "document cannot be null");
        getInternalDocuments().add(document);
        document.setPurpleHeart(this);
    }
    
    public void removePurpleHeartDocument(PurpleHeartDocument document) {
        Validate.notNull(document, "Document cannot be null");
        getInternalDocuments().remove(document);
        document.setPurpleHeart(null);
    }
    
	public void addDocument(PurpleHeartDocument document) {
        addPurpleHeartDocument(document);
	}

    public void addAllDocuments(Set documents) {
        Validate.notEmpty(documents, "PH documents cannot be null or empty");
        
        // Call addDocument to handle bidirectional relationship
        for (Iterator i = documents.iterator(); i.hasNext();) {
            Object document = i.next();
            if (document instanceof PurpleHeartDocument) {
                this.addPurpleHeartDocument((PurpleHeartDocument)document);
            }
        }
    }
    
	public void removeDocument(PurpleHeartDocument document) {
        removePurpleHeartDocument(document);
	}
    
    public PurpleHeartDocument getDocumentByEntityKey(EntityKey identifier) {
        return (PurpleHeartDocument) getEntityByEntityKey(getDocuments(),identifier);
    }

    public PurpleHeartDocument removeDocumentByEntityKey(EntityKey identifier) {
        return (PurpleHeartDocument) removeEntityByEntityKey(getInternalDocuments(),identifier);
    }

    public void removeAllDocuments() {
        getInternalDocuments().clear();
    }
    
    private Set getInternalDocuments() {
        if (internalDocuments == null) {
            this.internalDocuments = new HashSet();
        }
        return this.internalDocuments;
    }

    private void setInternalDocuments(Set internalDocuments) {
        this.internalDocuments = internalDocuments;
    }
    
	/*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder
            .append("rejectionRemark", this.rejectionRemark)
            .append("phIndicator", this.phIndicator)
            .append("facility", this.facility) 
            .append("status",this.status)
            .append("statusLastEditDate",this.statusLastEditDate)
            .append("statusLastUpdateUser",this.statusLastUpdateUser)
            .append("assignedContactUser",this.assignedContactUser)
        );
    }
} //  End of PurpleHeart Class
