package gov.va.med.esr.common.model.ee;

//----------------------------------------------------------------------------
//  Import third party library classes
//----------------------------------------------------------------------------
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.POWCampLocation;
import gov.va.med.esr.common.model.lookup.POWDataSource;
import gov.va.med.esr.common.model.lookup.POWDocumentType;
import gov.va.med.esr.common.model.lookup.PrisonerOfWarLocation;
import gov.va.med.esr.common.model.registry.Registry;

/**
 * @author Commons Team
 * @version 1.0
 */
public class PrisonerOfWarRecord extends Registry {
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7790636942564256641L;
	
	private ImpreciseDate         captureDate  = null;
	private ImpreciseDate         releaseDate  = null;
	private Date                  dateEntered  = null;
	private POWCampLocation       campLocation = null;
	private POWDataSource         dataSource   = null;
	private POWDocumentType       documentType = null;
	private Integer               numberOfDaysInCaptivity = null;
	
    /**
     * Confinement Location is defined as the war during which the veteran 
     * was confined.  It is the same as the VistA POW Confinement 
     * Location.  The values Include:
     1.	World War I
     2.	World War II - Europe
     3.	World War II- Pacific
     4.	Korea
     5.	Vietnam
     6.	Other
     7.	Persian Gulf War
     8.	Yugoslavia Conflict 
     */
    private PrisonerOfWarLocation location  = null;
 
    
    /** The system automatically sets the User value to the actors name 
     * who is adding or modifying the POW information. */ 
    private String                user      = null;
    
    /**
     * Creates a new PrisonerOfWarRecord object.
     */
    public PrisonerOfWarRecord() {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    public Date getDateEntered() {
    	return this.dateEntered;
    }
    
    public void setDateEntered(Date dateEntered) {
    	this.dateEntered = dateEntered;
    }
    
    public ImpreciseDate getCaptureDate() {
    	return this.captureDate;
    }
    
    public void setCaptureDate(ImpreciseDate captureDate) {
    	this.captureDate = captureDate;
    }

    public ImpreciseDate getReleaseDate() {
    	return this.releaseDate;
    }
    
    public void setReleaseDate(ImpreciseDate releaseDate) {
    	this.releaseDate = releaseDate;
    }
    
    public POWCampLocation getCampLocation() {
    	return this.campLocation; 
    }
    
    public void setCampLocation(POWCampLocation campLocation) {
    	this.campLocation = campLocation;
    }
    
    public POWDataSource getDataSource() {
    	return this.dataSource;
    }
    
    public void setDataSource(POWDataSource dataSource) {
        this.dataSource = dataSource;	
    }
    
    public POWDocumentType getDocumentType() {
    	return this.documentType;
    }
    
    public void setDocumentType(POWDocumentType documentType) {
        this.documentType = documentType;	
    }
    
    public Integer getNumberOfDaysInCaptivity() {
    	return this.numberOfDaysInCaptivity;
    }
    
    public void setNumberOfDaysInCaptivity(Integer numberOfDaysInCaptivity) {
    	this.numberOfDaysInCaptivity = numberOfDaysInCaptivity;
    }
    
    /**
     * Get the Location attribute
     *
     * @return The Location instance variable.
     * 
     * @hibernate.property
     */
    public PrisonerOfWarLocation getConfinementLocation() {
        return (location);
    }

    /**
     * Set the Location attribute
     *
     * @param  newLocation The value to set the Location instance variable to.
     */
    public void setConfinementLocation(PrisonerOfWarLocation newLocation) {
        location = newLocation;
    }
    
     public String getUser() {
    	return this.user;
    }
    
    public void setUser(String user) {
    	this.user = user;
    }

    /*
     * (non-Javadoc)
     *
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);

        builder.append("location", this.location);
        builder.append("campLocation", this.campLocation);
        builder.append("captureDate", this.captureDate);
        builder.append("dataSource", this.dataSource);
        builder.append("dateEntered", this.dateEntered);
        builder.append("documentType", this.documentType);
        builder.append("numberOfDaysInCaptivity", this.numberOfDaysInCaptivity);
        builder.append("releaseDate", this.releaseDate);
        builder.append("user", this.user);
    }
}

