package gov.va.med.esr.common.model.ee;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.POWCampLocation;
import gov.va.med.esr.common.model.lookup.POWDataSource;
import gov.va.med.esr.common.model.lookup.POWDocumentType;
import gov.va.med.esr.common.model.lookup.PrisonerOfWarLocation;

/**
 * @author Muddaiah Ranga
 * @version 1.0
 */
public class POWEpisode extends Document {

	private static final long serialVersionUID = -7790636942564256641L;
    
	private PrisonerOfWar         prisonerOfWar = null;
    private POWDocumentType       documentType = null;
    private POWDataSource         dataSource   = null;
	private ImpreciseDate         captureDate  = null;
	private ImpreciseDate         releaseDate  = null;
    private Integer               numberOfDaysInCaptivity = null;
    private Date                  dateEntered = null;
	private POWCampLocation       campLocation = null;
	
    /**
     * Confinement Location is defined as the war during which the veteran 
     * was confined.  It is the same as the VistA POW Confinement 
     * Location.  The values Include:
     1.	World War I
     2.	World War II - Europe
     3.	World War II- Pacific
     4.	Korea
     5.	Vietnam
     6.	Other
     7.	Persian Gulf War
     8.	Yugoslavia Conflict 
     */
    private PrisonerOfWarLocation location  = null;
    
    /**
     * Creates a new POWDocument object.
     */
    public POWEpisode() {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    public PrisonerOfWar getPrisonerOfWar() {
        return prisonerOfWar;
    }

    public void setPrisonerOfWar(PrisonerOfWar prisonerOfWar) {
        this.prisonerOfWar = prisonerOfWar;
    }
    
    public POWDocumentType getDocumentType() {
        return this.documentType;
    }
    
    public void setDocumentType(POWDocumentType documentType) {
        this.documentType = documentType;   
    }
    
    public POWDataSource getDataSource() {
        return this.dataSource;
    }
    
    public void setDataSource(POWDataSource dataSource) {
        this.dataSource = dataSource;   
    }
    
    public ImpreciseDate getCaptureDate() {
    	return this.captureDate;
    }
    
    public void setCaptureDate(ImpreciseDate captureDate) {
    	this.captureDate = captureDate;
    }

    public ImpreciseDate getReleaseDate() {
    	return this.releaseDate;
    }
    
    public void setReleaseDate(ImpreciseDate releaseDate) {
    	this.releaseDate = releaseDate;
    }
    
    public Integer getNumberOfDaysInCaptivity() {
        return this.numberOfDaysInCaptivity;
    }
    
    public void setNumberOfDaysInCaptivity(Integer numberOfDaysInCaptivity) {
        this.numberOfDaysInCaptivity = numberOfDaysInCaptivity;
    }
    
    public Date getDateEntered() {
        return this.dateEntered;
    }

    public void setDateEntered(Date dateEntered) {
        this.dateEntered = dateEntered;
    }

    public POWCampLocation getCampLocation() {
    	return this.campLocation; 
    }
    
    public void setCampLocation(POWCampLocation campLocation) {
    	this.campLocation = campLocation;
    }
    
    public PrisonerOfWarLocation getConfinementLocation() {
        return this.location;
    }

    public void setConfinementLocation(PrisonerOfWarLocation location) {
        this.location = location;
    }
    

    /*
     * (non-Javadoc)
     *
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("documentType", this.documentType);
        builder.append("dataSource", this.dataSource);
        builder.append("captureDate", this.captureDate);
        builder.append("releaseDate", this.releaseDate);
        builder.append("numberOfDaysInCaptivity", this.numberOfDaysInCaptivity);
        builder.append("campLocation", this.campLocation);
        builder.append("location", this.location);
        builder.append("dateEntered",this.dateEntered);
    }
}

