/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Nov 26, 2004
 */
package gov.va.med.esr.common.model.ee;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import java.util.Date;

//----------------------------------------------------------------------------
//  Import third party library classes
//----------------------------------------------------------------------------
import org.apache.commons.lang.builder.ToStringBuilder;
import gov.va.med.esr.common.model.lookup.NTRVerificationMethod;

//----------------------------------------------------------------------------
//  Import Framework classes
//----------------------------------------------------------------------------
import gov.va.med.esr.common.model.lookup.VAFacility;

import gov.va.med.esr.common.infra.TriState;


/**
 * 
 * 
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.subclass discriminator-value="3006879"
 *  
 */
public class NoseThroatRadium
    extends ClinicalDetermination
{

    //----------------------------------------------------------------------------
    // Static variable(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Static method(s)
    //--------------------------------------------------------l---------------

    //----------------------------------------------------------------------------
    // Constructor(s)
    //----------------------------------------------------------------------------

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1070847866293296313L;

	/**
     * Creates a new NoseThroatRadium object.
     */
    public NoseThroatRadium()
    {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    public Date getVerificationDate()
    {
        return this.verificationDate;
    }

    public void setVerificationDate(java.util.Date verificationDate)
    {
        this.verificationDate = verificationDate;
    }

    public NTRVerificationMethod getVerificationMethod()
    {
        return this.verificationMethod;
    }

    public void setVerificationMethod(NTRVerificationMethod verificationMethod)
    {
        this.verificationMethod = verificationMethod;
    }

    public TriState getReceivingTreatment()
    {
        return this.receivingTreatment;
    }

    public void setReceivingTreatment(TriState receivingTreatment)
    {
        this.receivingTreatment = receivingTreatment;
    }

    public VAFacility getVerificationFacility()
    {
        return this.verificationFacility;
    }

    public void setVerificationFacility(VAFacility verificationFacility)
    {
        this.verificationFacility = verificationFacility;
    }

    public Boolean isFromAviatorServiceBefore1955()
    {
        return this.fromAviatorServiceBefore1955;
    }

    public Boolean getFromAviatorServiceBefore1955()
    {
        return this.fromAviatorServiceBefore1955;
    }

    public void setFromAviatorServiceBefore1955(
        Boolean fromAviatorServiceBefore1955)
    {
        this.fromAviatorServiceBefore1955 = fromAviatorServiceBefore1955;
    }

    public Boolean isFromSubmarinerServiceBefore1965()
    {
        return this.fromSubmarinerServiceBefore1965;
    }

    public Boolean getFromSubmarinerServiceBefore1965()
    {
        return this.fromSubmarinerServiceBefore1965;
    }
    
    public void setFromSubmarinerServiceBefore1965(
        Boolean fromSubmarinerServiceBefore1965)
    {
        this.fromSubmarinerServiceBefore1965 = fromSubmarinerServiceBefore1965;
    }

     public Boolean getDiagnosedWithCancer()
     {
         return(diagnosedWithCancer);
     }


     
     /**
       * Set the DiagnosedWithCancer attribute
       *
       * @param  newDiagnosedWithCancer The value to set the DiagnosedWithCancer instance variable to.
       */
       public void setDiagnosedWithCancer(Boolean newDiagnosedWithCancer)
       {
           diagnosedWithCancer = newDiagnosedWithCancer; 
       }

    
       public Date getDiagnosisVerifiedDate() {
           return this.diagnosisVerifiedDate;
       }
       
       public void setDiagnosisVerifiedDate(Date dt) {
           this.diagnosisVerifiedDate = dt;
       }
              
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);

        builder.append("verificationDate", this.verificationDate);
        builder.append("verificationMethod", this.verificationMethod);
        builder.append("diagnosisVerifiedDate", this.diagnosisVerifiedDate);
        builder.append("receivingTreatment", this.receivingTreatment);
        builder.append("fromAviatorServiceBefore1955",
            this.fromAviatorServiceBefore1955);
        builder.append("fromSubmarinerServiceBefore1965",
            this.fromSubmarinerServiceBefore1965);
        builder.append("diagnosedWithCancer", this.diagnosedWithCancer);

    }

    //----------------------------------------------------------------------------
    // Package protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Private method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // All attributes that are not static
    //----------------------------------------------------------------------------

    /**
     * (NTR) Verification Date and Time is the date/time the documentation for
     * NTR was verified.
     * 
     */
    private Date verificationDate = null;

    /**
     * The (NTR) Verification Method is defined as a list of values that is used
     * to state the documentation used to verify the NTR claim. Values include:
     * M: Military Record S: Qualifying Military Service N: Not qualified.
     * 
     */
    private NTRVerificationMethod verificationMethod = null;

    /**
     * (NTR) Verification Method Station Number is defined as the Site that did
     * the Reporting of the Verification Method Status. Values are set on the
     * VistA system using the Institution file.
     * 
     */
    private VAFacility verificationFacility = null;

    /**
     * Received NTR Treatment defines the answer a veteran gave to the question:
     * DID YOU RECEIVE NOSE OR THROAT RADIUM TREATMENTS IN THE MILITARY? Values
     * include YES NO Unknown.
     * 
     */
    private TriState receivingTreatment = null;

    /**
     * Aviation Prior to 1955 is a defined as the question that is presented to
     * the user if the veteran has answered YES to the NTR Indicator. The
     * question is Did you serve as an aviator in the Military before Jan 31,
     * 1955? The values include YES/NO.
     * 
     * @hibernate.property insert="true" update="true"
     *                     column="NTR_AVIATOR_PRE1955_IND"
     */
    private Boolean fromAviatorServiceBefore1955 = null;

    /**
     * Submarine Trainee prior to 1965 is defined as the question that is
     * presented to the user if the veteran has answered YES to the NTR
     * Indicator. The question is Did you have submarine training in the
     * military before Jan 1, 1965? Values include YES/NO.
     * 
     */
    private Boolean fromSubmarinerServiceBefore1965 = null;

    /**
     *Diagnosed with Cancer of Head Neck is defined as the question that is presented to the user if the veteran has answered YES to the NTR Indicator.  Values include YES/NO. 
 Display Only on EDB. 

     */
     private Boolean diagnosedWithCancer = null;
     
     /* If for NTR the value is: Diagnosed With Head and Neck Cancer Date/Time (Precise)N/A for patient sensitivity
      * 
      */     
     private Date diagnosisVerifiedDate = null;
     
} //  End of NoseThroatRadium Class

