/*
 * MonetaryBenefit.java Copyright 2004, Veterans Health Administration All
 * rights reserved.
 */

// Generated 11/26/2004 10:24:04 AM
package gov.va.med.esr.common.model.ee;

// ----------------------------------------------------------------------------
// Import java classes
// ----------------------------------------------------------------------------
// import java.io.Serializable;

// ----------------------------------------------------------------------------
// Import third party library classes
// ----------------------------------------------------------------------------

import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang.builder.ToStringBuilder;

// ----------------------------------------------------------------------------
// Import Framework classes
// ----------------------------------------------------------------------------
import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.Indicator;

/**
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="VBA_FACTOR_DETAILS" where="T_VBA_FACTOR_TYPE = '01'"
 */
public class MonetaryBenefit extends AbstractKeyedEntity {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8811706282008647969L;
	
	private Set internalPensions = null;

	/**
	 * Creates a new MonetaryBenefit object.
	 */
	public MonetaryBenefit() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------
	public MonetaryBenefitAward getMonetaryBenefitAward() {
		return this.monetaryBenefitAward;
	}

	public void setMonetaryBenefitAward(MonetaryBenefitAward monetaryBenefitAward) {
		this.validateOwner(this.monetaryBenefitAward, monetaryBenefitAward);
		this.monetaryBenefitAward = monetaryBenefitAward;
	}

	public MonetaryBenefitType getType() {
		return this.type;
	}

	public void setType(MonetaryBenefitType type) {
		this.type = type;
	}

	/**
	 * @return Returns the monetaryBenefitIndicator.
	 */
	public Indicator getMonetaryBenefitIndicator() {
		return monetaryBenefitIndicator;
	}
	/**
	 * @param monetaryBenefitIndicator The monetaryBenefitIndicator to set.
	 */
	public void setMonetaryBenefitIndicator(Indicator monetaryBenefitIndicator) {
		this.monetaryBenefitIndicator = monetaryBenefitIndicator;
	}
	

   public Pension getPension() {
      Set pensions = getInternalPensions();
      if( pensions.size() > 0 ) {
         return (Pension)pensions.iterator().next();
      }
      return null;
   }
   
   public void setPension(Pension pension) {
	   Set pensions = getInternalPensions();
	   pensions.clear();
	     
	   if( pension != null ) {
	       pensions.add(pension);
	       pension.setMonetaryBenefit(this);
	   }
   }
   
   public boolean equals(Object rhs)
   {
	   
       if (rhs == null)
           return false;
       if (rhs == this)
    	   return true;
       if (rhs.getClass() != getClass()) 
           return false; 

       
       MonetaryBenefit that = (MonetaryBenefit) rhs;
       if (isEqual(this.getIdentifier(), that.getIdentifier()) &&
    		   isEqual(this.type,that.type) &&
    		   isEqual(this.monetaryBenefitIndicator,that.monetaryBenefitIndicator) &&
    		   isEqual(this.internalPensions,that.internalPensions))
       {
           return true;
       }
           
       return false;
   }
   
   private boolean isEqual(Object a, Object b)
   {
	   if (a == null)
	   {
		   return (b == null) ? true : false;
	   } else
	   {
		   return (b == null) ? false : a.equals(b);
	   }
   }

   /**
    * Implementation of the hashCode method conforming to the Bloch pattern with
    * the exception of array properties (these are very unlikely primary key types).
    * @return int
    */
   public int hashCode()
   {
       if (this.hashValue == 0)
       {
           int result = 17;
           int idValue = this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode();
           result = result * 37 + idValue;
           if(type != null){
        	   result = result * 37 + type.hashCode();        	   
           }           
           
           if (this.monetaryBenefitIndicator != null)
           {
        	   result = result * 37 + monetaryBenefitIndicator.hashCode();
           }
           
           if (this.internalPensions != null)
           {
        	   result = result * 37 + internalPensions.hashCode();
           }
           this.hashValue = result;
       }
       return this.hashValue;
   }
   
   
   
	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
        builder.append("type", this.type);
        builder.append("monetaryBenefitIndicator", this.monetaryBenefitIndicator);
	}

	// ----------------------------------------------------------------------------
	// Package protected method(s)
	// ----------------------------------------------------------------------------

	// ----------------------------------------------------------------------------
	// Protected method(s)
	// ----------------------------------------------------------------------------

	// ----------------------------------------------------------------------------
	// Private method(s)
	// ----------------------------------------------------------------------------
	  private Set getInternalPensions() {
	      if( internalPensions == null ) {
	         this.internalPensions = new HashSet();
	      }
	      return this.internalPensions;
	   }

	   private void setInternalPensions(Set internalPensions) {
	      this.internalPensions = internalPensions;
	   }

	// ----------------------------------------------------------------------------
	// All attributes that are not static
	// ----------------------------------------------------------------------------

	/**
	 * @hibernate.many-to-one class="MonetaryBenefitAward" not-null="true"
	 *                        insert="true" update="false"
	 * @hibernate.column name="VBA_FACTOR_ID"
	 */
	private MonetaryBenefitAward monetaryBenefitAward = null;

	/**
	 * Can be one of: AidAndAttendance, ReceivingDiabilityCompensation,
	 * Housebound, VAPension.
	 * 
	 * @hibernate.many-to-one class="gov.va.med.esr.common.model.lookup.MonetaryBenefitType"
	 *                        cascade="none" not-null="true" insert="true"
	 *                        update="true"
	 * @hibernate.column name="VBA_FACTOR_TYPE_ID"
	 */
	private MonetaryBenefitType type = null;

	/**
	 * MonetaryBenefit Indicator. This is a set of codes: 1- FOR PERMANENT; 2- FOR NOT PERMANENT; 3-
	 * FOR UNKNOWN
	 */
	private Indicator monetaryBenefitIndicator = null;
	
    private int hashValue = 0;

} // End of MonetaryBenefit Class
