/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Nov 26, 2004
 */
package gov.va.med.esr.common.model.ee;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import java.util.Date;

//----------------------------------------------------------------------------
//  Import third party library classes
//----------------------------------------------------------------------------
import org.apache.commons.lang.builder.ToStringBuilder;

//----------------------------------------------------------------------------
//  Import Framework classes
//----------------------------------------------------------------------------
import gov.va.med.esr.common.model.lookup.MilitarySexualTraumaStatus;

/**
 * 
 * 
 * @author Commons Team
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.subclass discriminator-value="3006881"
 *  
 */
public class MilitarySexualTrauma
    extends ClinicalDetermination
{

    //----------------------------------------------------------------------------
    // Static variable(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Static method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Constructor(s)
    //----------------------------------------------------------------------------

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -232838770875680952L;

	/**
     * Creates a new MilitarySexualTrauma object.
     */
    public MilitarySexualTrauma()
    {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    public MilitarySexualTraumaStatus getStatus()
    {
        return this.status;
    }

    public void setStatus(MilitarySexualTraumaStatus status)
    {
        this.status = status;
    }

    public Date getStatusChangeDate()
    {
        return this.statusChangeDate;
    }

    public void setStatusChangeDate(Date statusChangeDate)
    {
        this.statusChangeDate = statusChangeDate;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder
            .append("status", this.status)
            .append("statusChangeDate", this.statusChangeDate));
    }

    //----------------------------------------------------------------------------
    // Package protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Private method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // All attributes that are not static
    //----------------------------------------------------------------------------

    /**
     * MST Status Indicator is defined as the values that indicate if a veteran
     * has been clinically determined to have had Military Sexual Trauma. Values
     * include: Y -YES N-NO U- Unknown D -Declined to Answer.
     * 
     * @hibernate.many-to-one class="gov.va.med.esr.common.model.lookup.MilitarySexualTraumaStatus"
     *                        cascade="none" insert="true" update="true"
     * @hibernate.column name="MST_STATUS_ID"
     */
    private MilitarySexualTraumaStatus status = null;

    /**
     * @hibernate.property insert="true" update="true" column="START_DATE"
     */
    private Date statusChangeDate = null;

} //  End of MilitarySexualTrauma Class

