/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.ee;

// Java classes

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.MilitaryServiceComponent;
import gov.va.med.esr.common.model.lookup.ServiceBranch;

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents a Military Service Episode
 * Record which is contained by a Military Service Site Record.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class MilitaryServiceEpisode
    extends AbstractKeyedEntity {
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8076839115524890587L;
	private MilitaryServiceSiteRecord militaryServiceSiteRecord = null;
    private ServiceBranch             serviceBranch             = null;
    private DischargeType             dischargeType             = null;
    private MilitaryServiceComponent  militaryServiceComponent  = null;
    private String                    serviceNumber             = null;
    private ImpreciseDate             startDate                 = null;
    private ImpreciseDate             endDate                   = null;

    /**
     * Default constructor.
     */
    public MilitaryServiceEpisode() {
        super();
    }

    public ImpreciseDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(ImpreciseDate startDate) {
        this.startDate = startDate;
    }

    public ImpreciseDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(ImpreciseDate endDate) {
        this.endDate = endDate;
    }

    public ServiceBranch getServiceBranch() {
        return this.serviceBranch;
    }

    public void setServiceBranch(ServiceBranch serviceBranch) {
        this.serviceBranch = serviceBranch;
    }

    public String getServiceNumber() {
        return this.serviceNumber;
    }

    public void setServiceNumber(String serviceNumber) {
        this.serviceNumber = serviceNumber;
    }

    public DischargeType getDischargeType() {
        return this.dischargeType;
    }

    public void setDischargeType(DischargeType dischargeType) {
        this.dischargeType = dischargeType;
    }

    public MilitaryServiceComponent getMilitaryServiceComponent() {
        return militaryServiceComponent;
    }

    public void setMilitaryServiceComponent(
            MilitaryServiceComponent militaryServiceComponent) {
        this.militaryServiceComponent = militaryServiceComponent;
    }

    public MilitaryServiceSiteRecord getMilitaryServiceSiteRecord() {
        return this.militaryServiceSiteRecord;
    }

    public void setMilitaryServiceSiteRecord(
            MilitaryServiceSiteRecord militaryServiceSiteRecord) {

    	this.validateOwner(this.militaryServiceSiteRecord,militaryServiceSiteRecord);        
        this.militaryServiceSiteRecord = militaryServiceSiteRecord;
    }

    /**
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("startDate", this.startDate);
        builder.append("endDate", this.endDate);
        builder.append("serviceBranch", this.serviceBranch);
        builder.append("serviceNumber", this.serviceNumber);
        builder.append("militaryServiceComponent", this.militaryServiceComponent);
        builder.append("dischargeType", this.dischargeType);
    }
}