/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Jan 6, 2005
 */
package gov.va.med.esr.common.model.ee;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Commons Team
 * @version 1.0
 */
public class MedicaidFactor
    extends AbstractKeyedEntity
{

    //----------------------------------------------------------------------------
    // Static variable(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Static method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Constructor(s)
    //----------------------------------------------------------------------------

    /**
	 * An instance of serialVersionUID
	 */
	//private static final long serialVersionUID = -7732818081801142823L;

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 4156828698977022983L;

	/**
     * default constructor
     */
    public MedicaidFactor()
    {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------
    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) 
    {
        this.validateOwner(this.person,person);
        this.person = person;
    }
    
    public Boolean isEligibleForMedicaid()
    {
        return this.eligibleForMedicaid;
    }
    
    /**
     * Needed for copyService
     * 
     * @return
     */
    public Boolean getEligibleForMedicaid()
    {
        return this.eligibleForMedicaid;
    }    

    public void setEligibleForMedicaid(Boolean isEligibleForMedicaid)
    {
        this.eligibleForMedicaid = isEligibleForMedicaid;
    }

    public Date getLastUpdateDate()
    {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(Date lastUpdateDate)
    {
        this.lastUpdateDate = lastUpdateDate;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        builder
            .append("eligibleForMedicaid", this.eligibleForMedicaid)
            .append("lastUpdateDate", this.lastUpdateDate);
    }

    //----------------------------------------------------------------------------
    // Package protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Private method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // All attributes that are not static
    //----------------------------------------------------------------------------

    /**
     * Eligible for Medicaid Indicator is defined as a code to indicate if this
     * patient is eligible to receive Medicaid coverage. Yes/No
     */
    private Boolean eligibleForMedicaid = null;

    /**
     * Date Medicaid last updated is defined as the date that the Eligible for
     * Medicaid indicator was last updatedCannot be a future date
     */
    private Date lastUpdateDate = null;

    /**
     * keep one-to-many bi-direction relationship
     */
    private Person person = null;

}
