package gov.va.med.esr.common.model.ee;

import java.util.Date;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.PHDocumentType;
import gov.va.med.esr.common.model.lookup.MHDataSource;

/**
 * 
 * @author DNS   ruizc
 * @version 1.0
 *
 */
public class MedalOfHonor extends AbstractKeyedEntity implements Decoration {

    /**
	 * 
	 */
	private static final long serialVersionUID = -3797755556658019305L;

	private Person person = null;
    
    // Date/Time Updated
    private Date dateLastEdited = null;
    
    // Decoration Status
	private DecorationStatus status = null;
	
	// MH Indicator
	private Boolean mhIndicator = null;
	
	// Decoration Document Type
	private PHDocumentType documentType = null;
	
	// Data Source
	private MHDataSource dataSource = null;
	
	// MH Status Update Date
	private Date statusLastUpdateDate = null;
	
	// Document Receipt Date
	private Date documentReceiptDate = null;
	
	public DecorationStatus getStatus() {
		return this.status;
	}

	public void setStatus(DecorationStatus status) {
		this.status = status;
	}

	public Person getPerson() {
		return this.person;
	}

	public void setPerson(Person person) {
		this.validateOwner(this.person,person);
		this.person = person;
	}
	

	public MHDataSource getDataSource() {
		return dataSource;
	}

	public void setDataSource(MHDataSource dataSource) {
		this.dataSource = dataSource;
	}

	public Date getDateLastEdited() {
		return dateLastEdited;
	}

	public void setDateLastEdited(Date dateLastEdited) {
		this.dateLastEdited = dateLastEdited;
	}

	public Date getDocumentReceiptDate() {
		return documentReceiptDate;
	}

	public void setDocumentReceiptDate(Date documentReceiptDate) {
		this.documentReceiptDate = documentReceiptDate;
	}

	public PHDocumentType getDocumentType() {
		return documentType;
	}

	public void setDocumentType(PHDocumentType documentType) {
		this.documentType = documentType;
	}

	public Boolean getMhIndicator() {
		return mhIndicator;
	}

	public void setMhIndicator(Boolean mhIndicator) {
		this.mhIndicator = mhIndicator;
	}

	public Date getStatusLastUpdateDate() {
		return statusLastUpdateDate;
	}

	public void setStatusLastUpdateDate(Date statusLastUpdateDate) {
		this.statusLastUpdateDate = statusLastUpdateDate;
	}

}
