package gov.va.med.esr.common.model.ee;


import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;


/**
 * WI# 218485
 * Created Sep 1, 2015
 * @author DNS   faulkj
 */
public class MECPeriod
    extends AbstractKeyedEntity
{
    private static final long serialVersionUID = -1370346756640850300L;
    /**
     * Creates a new MECPeriod object.
     */
    public MECPeriod()
    {
        super();
    }

    /* mecStartDate and mecEndDate will be null for objects that represent
     * multiple combined periods
     * in those cases only coverageMonths map and/or the coveredAll12Months flag will be set
     * The dates will be populated usually only when retrieving specific period row for person
     * to be displayed by individual periods in UI
     * or when retrieving periods to intersect the VRS/CMS queries
     *
     */

    private BigDecimal personId = null;
    private Date mecStartDate = null;

    /*
     * endDate will remain null for periods that are still active
     */
    private Date mecEndDate = null;

    /*
     * coverageMonths map can contain duplicate months for situations of multiple
     * periods in the year where person ended and re-started enrollment in same month
     * i.e. enrolled period 1/4/2015 - 6/2/2015
     * next period start 6/28/2015 - null(active)
     * would put two June's in the map as true
     */
    private HashMap coverageMonths = null;


    /*
     * if this flag is true, the coverageMonths map may be empty most situations
     * consider all months separately as true if this flag is true, regardless of contents of map
     */
    private boolean isCoveredAll12Months = false;


	public boolean isCoveredAll12Months() {

		return isCoveredAll12Months;
	}

	public void setCoveredAll12Months(boolean isCoveredAll12Months) {
		this.isCoveredAll12Months = isCoveredAll12Months;
	}

	public Date getMecStartDate() {
		return mecStartDate;
	}

	public void setMecStartDate(Date mecStartDate) {
		this.mecStartDate = mecStartDate;
	}

	public Date getMecEndDate() {
		return mecEndDate;
	}

	public void setMecEndDate(Date mecEndDate) {
		this.mecEndDate = mecEndDate;
	}

	public HashMap getCoverageMonths() {
		if (this.isCoveredAll12Months)
			return completeMap();

		return coverageMonths;
	}

	private HashMap completeMap() {
		HashMap fullYear = new HashMap();
		for (int i = 1; i <= 12; i++) {
			fullYear.put(Integer.toString(i), true);
		}
		return fullYear;
	}

	public void setCoverageMonths(HashMap coverageMonths) {
		this.coverageMonths = coverageMonths;
	}

	 public BigDecimal getPersonId() {
		return personId;
	}

	public void setPersonId(BigDecimal personId) {
		this.personId = personId;
	}


	protected void buildToString(ToStringBuilder builder)
	    {
	        super.buildToString(builder);
	        builder.append("personId", this.personId);
	        builder.append("mecStartDate", this.mecStartDate);
	        builder.append("mecEndDate", this.mecEndDate);
	        builder.append("isCoveredAll12Months", this.isCoveredAll12Months);
	        builder.append("coverageMonths", this.coverageMonths);
	    }

}
