/*
 * IneligibilityFactor.java
 * Copyright 2004,
 * Veterans Health Administration
 * All rights reserved.
 */

// Generated 11/19/2004 11:29:37 AM 
package gov.va.med.esr.common.model.ee;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------
import java.util.Date;

//----------------------------------------------------------------------------
//  Import third party library classes
//----------------------------------------------------------------------------
import org.apache.commons.lang.builder.ToStringBuilder;

//----------------------------------------------------------------------------
//  Import Framework classes
//----------------------------------------------------------------------------
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * 
 * 
 * @author Common
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="INELIGIBILITY"
 *  
 */
public class IneligibilityFactor
    extends AbstractKeyedEntity
{

    //----------------------------------------------------------------------------
    // Static variable(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Static method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Constructor(s)
    //----------------------------------------------------------------------------

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6185008792680906891L;

	/**
     * Creates a new IneligibilityFactor object.
     */
    public IneligibilityFactor()
    {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    public Person getPerson()
    {
        return this.person;
    }

    public void setPerson(Person person)
    {
        this.validateOwner(this.person,person);        
        this.person = person;
    }

    public Date getIneligibleDate()
    {
        return this.ineligibleDate;
    }

    public void setIneligibleDate(Date ineligibleDate)
    {
        this.ineligibleDate = ineligibleDate;
    }

    public String getReason()
    {
        return this.reason;
    }

    public void setReason(String reason)
    {
        this.reason = reason;
    }

    public String getVaroDecision()
    {
        return this.varoDecision;
    }

    public void setVaroDecision(String varoDecision)
    {
        this.varoDecision = varoDecision;
    }

	/**
	 * @param facilityReceived The facilityReceived to set.
	 */
	public void setFacilityReceived(VAFacility receivedFacility) {
		this.facilityReceived = receivedFacility;
	}

	/**
	 * @return Returns the facilityReceived.
	 */
	public VAFacility getFacilityReceived() {
		return facilityReceived;
	}

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder
            .append("ineligibleDate", this.ineligibleDate)
            .append("reason", this.reason)
            .append("varoDecision", this.varoDecision)
        	.append("facilityReceived", this.facilityReceived));
   }

    //----------------------------------------------------------------------------
    // Package protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Private method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // All attributes that are not static
    //----------------------------------------------------------------------------

    /**
     * @hibernate.many-to-one class="gov.va.med.esr.common.model.person.Person"
     *                        not-null="true" insert="true" update="false"
     * @hibernate.column name="PARTY_ID"
     */
    private Person person = null;

    /**
	 * Ineligible date is defined as the effective date this veteran was found
	 * to be ineligible for VHA healthcare.
	 * 
	 * @hibernate.property insert="true" update="true" column="START_DATE"
	 */
    private Date ineligibleDate = null;

    /**
	 * Ineligible Reason is defined as the free text entry made by the user if
	 * the veteran is ineligible for treatment . It is not to exceed 40
	 * characters.. An ineligible date must be specified in order to enter/edit
	 * this field and This field may not be deleted as long as an ineligible
	 * date is on file
	 * 
	 * @hibernate.property insert="true" update="true" column="COMMENT_TEXT"
	 *                     length="2000"
	 */
    private String reason = null;

    /**
	 * The Ineligible VARO Decision is defined as the VARO decision concerning
	 * this applicant's ineligibility. This field is between 3-75 characters. An
	 * ineligible date must be specified in order to enter/edit this field.
	 * 
	 * @hibernate.property insert="true" update="true"
	 *                     column="REGIONAL_OFFICE_DECISION_TEXT" length="150"
	 */
    private String varoDecision = null;
    
    /**
     * Site that sent the ineligibility data
     */
    private VAFacility facilityReceived = null;
} //  End of IneligibilityFactor Class
