package gov.va.med.esr.common.model.ee;

//----------------------------------------------------------------------------
//  Import java classes
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
//  Import third party library classes
//----------------------------------------------------------------------------

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Commons Team
 * @version 1.0
 */
public class IncompetenceRuling
    extends AbstractKeyedEntity {
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3977618511068774076L;
	//----------------------------------------------------------------------------
    // All attributes that are not static
    //----------------------------------------------------------------------------
    private Person        person          = null;
    private ImpreciseDate civilRulingDate = null;
    private ImpreciseDate vaRulingDate    = null;
    private Boolean       incompetent     = null;

    //----------------------------------------------------------------------------
    // Constructor(s)
    //----------------------------------------------------------------------------

    /**
     * Creates a new IncompetenceRuling object.
     */
    public IncompetenceRuling() {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person,person);
        this.person = person;
    }

    public ImpreciseDate getCivilRulingDate() {
        return this.civilRulingDate;
    }

    public void setCivilRulingDate(ImpreciseDate civilRulingDate) {
        this.civilRulingDate = civilRulingDate;
    }

    public ImpreciseDate getVaRulingDate() {
        return this.vaRulingDate;
    }

    public void setVaRulingDate(ImpreciseDate vaRulingDate) {
        this.vaRulingDate = vaRulingDate;
    }

    public Boolean isIncompetent() {
        return this.incompetent;
    }
    
    // For copyService
    public Boolean getIncompetent() {
        return this.incompetent;
    }    

    public void setIncompetent(Boolean incompetent) {
        this.incompetent = incompetent;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder.append("civilRulingDate",
                this.civilRulingDate).append("incompetent", this.incompetent).append(
                "vaRulingDate", this.vaRulingDate));
    }

    //----------------------------------------------------------------------------
    // Package protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Protected method(s)
    //----------------------------------------------------------------------------

    //----------------------------------------------------------------------------
    // Private method(s)
    //----------------------------------------------------------------------------

}