package gov.va.med.esr.common.model.ee;


// Java classes
import java.util.Date;

// Library classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework classes
import gov.va.med.fw.model.AbstractEntity;

// ESR classes
import gov.va.med.esr.common.model.lookup.VAFacility;

/**
 * This object is a parameter object for use by
 * incoming messages. Not part of BOM.
 * 
 * @author DNS   RUIZC
 */
public class IncomingMessageInfo extends AbstractEntity {

    /**
     * 
     */
    private static final long serialVersionUID = -3363271264520018829L;

    private String referenceMessageId = null;
    private VAFacility sendingFacility = null;
    private Date  queryDateTime = null;
    private String dfn = null;
    
    public IncomingMessageInfo() {
        super();
    }        
    
    /**
     * 
     * @param referenceMessageId
     * @param sendingFacility
     * @param queryDateTime
     */
    public IncomingMessageInfo(String referenceMessageId, VAFacility sendingFacility, Date  queryDateTime) {
        super();

        this.referenceMessageId = referenceMessageId;
        this.sendingFacility = sendingFacility;
        this.queryDateTime = queryDateTime;
    }
    
    /**
     * @return Returns the queryDateTime.
     */
    public Date getQueryDateTime() {
        return queryDateTime;
    }

    /**
     * @param queryDateTime The queryDateTime to set.
     */
    public void setQueryDateTime(Date queryDateTime) {
        this.queryDateTime = queryDateTime;
    }

    /**
     * @return Returns the referenceMessageId.
     */
    public String getReferenceMessageId() {
        return referenceMessageId;
    }

    /**
     * @param referenceMessageId The referenceMessageId to set.
     */
    public void setReferenceMessageId(String referenceMessageId) {
        this.referenceMessageId = referenceMessageId;
    }

    /**
     * @return Returns the sendingFacility.
     */
    public VAFacility getSendingFacility() {
        return sendingFacility;
    }

    /**
     * @param sendingFacility The sendingFacility to set.
     */
    public void setSendingFacility(VAFacility sendingFacility) {
        this.sendingFacility = sendingFacility;
    }
    
    
    /**
     * @return Returns the ssnText.
     */
    protected void buildToString(ToStringBuilder builder) {
        builder.append("queryDateTime", this.queryDateTime);
        builder.append("referenceMessageId", this.referenceMessageId);
        builder.append("sendingFacility", this.sendingFacility);
        builder.append("dfn", this.dfn);
   }

	public String getDfn() {
		return dfn;
	}

	public void setDfn(String dfn) {
		this.dfn = dfn;
	}
}
