package gov.va.med.esr.common.model.ee;



import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

import gov.va.med.esr.common.model.party.SimpleAddress;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;


/**
 * WI#
 * Created Sep 1, 2015
 * @author DNS   faulkj
 */
public class IRS1095B
    extends AbstractKeyedEntity
{
    private static final long serialVersionUID = -1370346756740850300L;
    /**
     * Creates a new IRS1095B object.
     */
    public IRS1095B()
    {
        super();
    }

    public IRS1095B(Person person) {
    	super();
    	this.address = person.getPermanentAddress();
		this.DOB = person.getIdentityTraits().getBirthRecord().getBirthDate().toStandardFormat();
		this.firstName = person.getIdentityTraits().getLegalName().getGivenName();
		this.IEN = person.getVPIDValue();
		this.lastName = person.getIdentityTraits().getLegalName().getFamilyName();
		this.middleName = person.getIdentityTraits().getLegalName().getMiddleName();
		this.namePrefix = person.getIdentityTraits().getLegalName().getPrefix();
		this.nameSuffix = person.getIdentityTraits().getLegalName().getSuffix();
		this.gender = (person.getIdentityTraits().getGender() != null ? person.getIdentityTraits().getGender().getCode() : "");
		this.SSN = person.getIdentityTraits().getSsnText();
    }

    /* TODO constructor for IRS Xtion log entry obj
    public IRS1095B(IRSTransmissionLoDetail entry) {
    	super();
    	this.
    }*/

    private String namePrefix = null;
    private String firstName = null;
    private String middleName = null;
    private String lastName = null;
    private String nameSuffix = null;
    private String gender = null;
    private String IEN = null;
    private String SSN = null;
    private String DOB = null;
    private SimpleAddress address = null;
    private MECPeriod mecPeriod = null;
    private String coverageMonthsDisplay = "";
    private String errorText;
    private Long id;



	public String getNamePrefix() {
		return namePrefix;
	}



	public void setNamePrefix(String namePrefix) {
		this.namePrefix = namePrefix;
	}



	public String getFirstName() {
		return firstName;
	}



	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}



	public String getMiddleName() {
		return middleName;
	}



	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}



	public String getLastName() {
		return lastName;
	}



	public void setLastName(String lastName) {
		this.lastName = lastName;
	}



	public String getNameSuffix() {
		return nameSuffix;
	}



	public void setNameSuffix(String nameSuffix) {
		this.nameSuffix = nameSuffix;
	}



	public String getIEN() {
		return IEN;
	}



	public void setIEN(String iEN) {
		IEN = iEN;
	}



	public String getSSN() {
		return SSN;
	}



	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public void setSSN(String sSN) {
		SSN = sSN;
	}



	public String getDOB() {
		return DOB;
	}



	public void setDOB(String DOB) {
		this.DOB = DOB;
	}



	public SimpleAddress getAddress() {
		return address;
	}



	public void setAddress(SimpleAddress address) {
		this.address = address;
	}



	public MECPeriod getMecPeriod() {
		return mecPeriod;
	}



	public void setMecPeriod(MECPeriod mecPeriod) {
		this.mecPeriod = mecPeriod;
	}


	public String getCoverageMonthsDisplay() {

		if (this.getMecPeriod().getCoverageMonths() != null) {
			coverageMonthsDisplay = "";
			HashMap coverageMonths = this.getMecPeriod().getCoverageMonths();
			if (coverageMonths.containsKey("1") && (Boolean)coverageMonths.get("1")) coverageMonthsDisplay += "Jan, ";
			if (coverageMonths.containsKey("2") && (Boolean)coverageMonths.get("2")) coverageMonthsDisplay += "Feb, ";
			if (coverageMonths.containsKey("3") && (Boolean)coverageMonths.get("3")) coverageMonthsDisplay += "Mar, ";
			if (coverageMonths.containsKey("4") && (Boolean)coverageMonths.get("4")) coverageMonthsDisplay += "Apr, ";
			if (coverageMonths.containsKey("5") && (Boolean)coverageMonths.get("5")) coverageMonthsDisplay += "May, ";
			if (coverageMonths.containsKey("6") && (Boolean)coverageMonths.get("6")) coverageMonthsDisplay += "Jun, ";
			if (coverageMonths.containsKey("7") && (Boolean)coverageMonths.get("7")) coverageMonthsDisplay += "Jul, ";
			if (coverageMonths.containsKey("8") && (Boolean)coverageMonths.get("8")) coverageMonthsDisplay += "Aug, ";
			if (coverageMonths.containsKey("9") && (Boolean)coverageMonths.get("9")) coverageMonthsDisplay += "Sep, ";
			if (coverageMonths.containsKey("10") && (Boolean)coverageMonths.get("10")) coverageMonthsDisplay += "Oct, ";
			if (coverageMonths.containsKey("11") && (Boolean)coverageMonths.get("11")) coverageMonthsDisplay += "Nov, ";
			if (coverageMonths.containsKey("12") && (Boolean)coverageMonths.get("12")) coverageMonthsDisplay += "Dec ";

		}

		return coverageMonthsDisplay;
	}

	public String getErrorText() {
		return errorText;
	}

	public void setErrorText(String errorText) {
		this.errorText = errorText;
	}

	public void setCoverageMonthsDisplay(String coverageMonthsDisplay) {
		this.coverageMonthsDisplay = coverageMonthsDisplay;
	}


	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	@Override
	public String toString() {
		return "IRS1095B [namePrefix=" + namePrefix + ", firstName="
				+ firstName + ", middleName=" + middleName + ", lastName="
				+ lastName + ", nameSuffix=" + nameSuffix + ", IEN=" + IEN
				//+ ", SSN=" + SSN + 
				+ ", DOB=" + DOB + ", address=" + address
				+ ", mecPeriod=" + mecPeriod + "]";
	}

}
