/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.model.ee;

// Java classes
import java.util.Date;

// Library classes

// Framework classes
import gov.va.med.fw.model.AbstractKeyedEntity;

// EDB Classes
import gov.va.med.esr.common.model.lookup.FeeBasisProgram;
import gov.va.med.esr.common.model.lookup.FeeBasisTreatmentType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Yi He
 * @version 1.0
 */
public class FeeBasis extends AbstractKeyedEntity {

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2024788026222134735L;

	/**
     * 
     */
    public FeeBasis() {
        super();
    }
    
    public Person getPerson()
    {
        return this.person;
    }

    public void setPerson(Person person)
    {
        this.validateOwner(this.person,person);        
        this.person = person;
    }
    

    public Date getAuthorizationFromDate() {
        return this.authorizationFromDate;
    }
    
    public void setAuthorizationFromDate(Date date) {
        this.authorizationFromDate = date;      
    }
    
    public Date getAuthorizationToDate() {
        return this.authorizationToDate;
    }
    
    public void setAuthorizationToDate(Date date) {
        this.authorizationToDate = date;      
    }
    
    public Date getReportDate() {
        return this.reportDate;
    }
    
    public void setReportDate(Date date) {
        this.reportDate = date;
    }
    
    public VAFacility getReportSite() {
        return this.reportSite;
    }
    
    public void setReportSite(VAFacility site) {
        this.reportSite = site;
    }
    
    public FeeBasisProgram getProgram() {
        return this.program;
    }
    
    public void setProgram(FeeBasisProgram program) {
        this.program = program;    
    }
    
    public FeeBasisTreatmentType getTreatmentType() {
        return this.treatmentType;
    }
    
    public void setTreatmentType(FeeBasisTreatmentType treatmentType) {
        this.treatmentType = treatmentType;
    }
        
    private Date authorizationFromDate = null;
    
    private Date authorizationToDate = null;
    
    private Date reportDate = null;

    private VAFacility reportSite = null;
    
    private FeeBasisProgram program = null;
    
    private FeeBasisTreatmentType treatmentType = null;       
    
    private Person person = null;
}

