/*******************************************************************************
 * Copyright  2005 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.ee;

// Java classes

// Library classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework classes

// ESR classes
import gov.va.med.esr.common.model.lookup.Indicator;

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents an Environmental Contamination Exposure special factor.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class EnvironmentalContaminationExposure extends SpecialFactor {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 2245643016582482774L;

	/**
	 * Default Constructor.
	 */
	public EnvironmentalContaminationExposure() {
		super();
	}

	/**
	 * @return Returns the agentOrangeExposureIndicator.
	 */
	public Indicator getEnvironmentalContaminationExposureIndicator() {
		return specialFactorIndicator;
	}

	/**
	 * @param agentOrangeExposureIndicator The agentOrangeExposureIndicator to set.
	 */
	public void setEnvironmentalContaminationExposureIndicator(
			Indicator environmentalContaminationExposureIndicator) {
		this.specialFactorIndicator = environmentalContaminationExposureIndicator;
	}
	/**
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
        builder.append("environmentalContaminationExposureIndicator", this.specialFactorIndicator);
	}
}
