/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Jul 8, 2005
 *
 */
package gov.va.med.esr.common.model.ee;




// Java classes
import java.util.Date;

// Library classes

// Framework classes
import gov.va.med.fw.model.AbstractKeyedEntity;

// EDB Classes
import gov.va.med.esr.common.model.lookup.EnrollmentOverrideReason;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Yi He
 * @version 1.0
 * This class captures the settings used for override enrollment. 
 * It serves to both keeping the record of the settings and 
 * to initiate processing the override.
 */
public class EnrollmentOverride extends AbstractKeyedEntity {

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 5059552028220685830L;

	/**
     * 
     */
    public EnrollmentOverride() {
        super();
    }
    
    
    public Boolean getOverride() {
        return this.override;
    }
    
    public void setOverride(Boolean override) {
        this.override = override;
    }
    
    public EnrollmentOverrideReason getOverrideReason() {
        return this.overrideReason;
    }
    
    public void setOverrideReason(EnrollmentOverrideReason reason) {
        this.overrideReason = reason;
    }
    
    public String getOverrideComment() {
        return this.overrideComment;
    }
    
    public void setOverrideComment(String comment) {
        this.overrideComment = comment;
    }
    
    public Date getOverrideDate() {
        return this.overrideDate;
    }
    
    public void setOverrideDate(Date date) {
        this.overrideDate = date;    
    }
    
    public String getOverrideBy() {
        return this.overrideBy;
    }
    
    public void setOverrideBy(String overrideBy) {
        this.overrideBy = overrideBy;
    }

    /*
     * When set to the TRUE, the enrollment rule set will
     * process the settings in this object to override enrollment.
     * When set to FALSE(default), the settings are not processed, they 
     * are just used to record keeping and displayed.
     * If the client of enrollment rule set (e.g. UI) wants to 
     * initiate enrollment override, set this value to TRUE. Otherwise, DO
     * NOT set it to TRUE. Enrollment rule set will set back to FALSE after
     * processing the override.
     * 
     */    
    public Boolean getProcessOverride() {
        return this.processOverride;
    }
    
    /*
     * When set to the TRUE, the enrollment rule set will
     * process the settings in this object to override enrollment.
     * When set to FALSE(default), the settings are not processed, they 
     * are just used to record keeping and displayed.
     * If the client of enrollment rule set (e.g. UI) wants to 
     * initiate enrollment override, set this value to TRUE. Otherwise, DO
     * NOT set it to TRUE. Enrollment rule set will set back to FALSE after
     * processing the override.
     * 
     */
    
    public void setProcessOverride(Boolean processOverride) {
        this.processOverride = processOverride;
    }
    
    public Person getPerson() {
        return this.person;
    }
    
    public void setPerson(Person person) {
        this.validateOwner(this.person,person);
        this.person = person;
    }
    
    private Boolean override = null;
    
    private EnrollmentOverrideReason overrideReason = null;
    
    private String overrideComment = null;
    
    private Date overrideDate = null;
    
    private String overrideBy = null;

    private Person person = null;

    /*
     * When set to the TRUE, the enrollment rule set will
     * process the settings in this object to override enrollment.
     * When set to FALSE(default), the settings are not processed, they 
     * are just used to record keeping and displayed.
     * If the client of enrollment rule set (e.g. UI) wants to 
     * initiate enrollment override, set this value to TRUE. Otherwise, DO
     * NOT set it to TRUE. Enrollment rule set will set back to FALSE after
     * processing the override.
     * 
     */
    private Boolean processOverride = Boolean.FALSE;
}

