/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/

package gov.va.med.esr.common.model.ee;


import java.util.Arrays;
import java.lang.Comparable;


import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.EligibilityFactor;

/**
 * @author Commons Team
 * @version 1.0
 */
public class Eligibility extends AbstractKeyedEntity implements Comparable{
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -753278036054366763L;

	private static final String PRIMARY_IND = "P";

	private static final String SECONDARY_IND = "S";

	private static final String OTHER_IND = "O";

	private EnrollmentDetermination enrollmentDetermination = null;

	private EligibilityType type = null;

	private EligibilityFactor factor = null;

	private String indicator = null;

	/**
	 * Creates a new Eligibility object.
	 */
	public Eligibility() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------
	public EnrollmentDetermination getEnrollmentDetermination() {
		return this.enrollmentDetermination;
	}

	public void setEnrollmentDetermination(
			EnrollmentDetermination enrollmentDetermination) {
		this.validateOwner(this.enrollmentDetermination, enrollmentDetermination);
		this.enrollmentDetermination = enrollmentDetermination;
	}

	public EligibilityType getType() {
		return this.type;
	}

	public void setType(EligibilityType type) {
		this.type = type;
	}

	public EligibilityFactor getFactor() {
		return this.factor;
	}

	public void setFactor(EligibilityFactor factor) {
		this.factor = factor;
	}

	private void setIndicator(String indicator) {
		this.indicator = indicator;
	}

	public String getIndicator() {
		return this.indicator;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("type", this.getType() );
		builder.append("factor", this.getFactor() );
		builder.append("indicator", this.getIndicator() );
	}

	public void setPrimary() {
		setIndicator(PRIMARY_IND);
	}

	public void setSecondary() {
		setIndicator(SECONDARY_IND);
	}

	public void setOther() {
		setIndicator(OTHER_IND);
	}
	
	/**
	 * Sort oder for Secondary Eligibility
	 */
    public int compareTo(Object o)
    {
    	if (o == null || !(o instanceof Eligibility)) 
    		return -1;
    	else if (this.equals(o))
    		return 0;
    	else if (!this.getIndicator().equals(SECONDARY_IND)
    			|| !((Eligibility)o).getIndicator().equals(SECONDARY_IND))
    		return 0;
    	else
    	{
    		EligibilityType thisType = this.getType();
    		EligibilityType oType = ((Eligibility)o).getType();
    		
    		return getOrder(thisType) - getOrder(oType);
    	}
    }
	/**
	 * Sort oder for Secondary Eligibility
		Prisoner of War
		Purple Heart Recipient
		Aid & Attendance
		Housebound
		NSC, VA Pension
		World War I
		//Non- Veteran Eligibility Codes:
		Humanitarian Emergency
		TRICARE
		Sharing Agreement
		Allied Veteran
		CHAMPVA
		Employee
		Collateral of Vet
		Other Federal Agency

	 */   
    private int getOrder(EligibilityType type)
    {
    	Object[] objs = 
    	{
    			EligibilityType.PRISONER_OF_WAR.getName(),
				EligibilityType.PURPLE_HEART_RECIPIENT.getName(),
				EligibilityType.AID_AND_ATTENDANCE.getName(),
				EligibilityType.HOUSEBOUND.getName(),
				EligibilityType.NSC_VA_PENSION.getName(),
				EligibilityType.WORLD_WAR_I.getName(),
				EligibilityType.HUMANTARIAN_EMERGENCY.getName(),
				EligibilityType.TRICARE_CHAMPUS.getName(),
				EligibilityType.SHARING_AGREEMENT.getName(),
				EligibilityType.ALLIED_VETERAN.getName(),
				EligibilityType.CHAMPVA.getName(),
				EligibilityType.EMPLOYEE.getName(),
				EligibilityType.COLLATERAL_OF_VETERAN.getName(),
				EligibilityType.OTHER_FEDERAL_AGENCY.getName()
		};
    	int order = Arrays.asList(objs).indexOf(type.getCode());
    	return order;
    	
//    	if (type.getCode().equals(EligibilityType.PRISONER_OF_WAR.getName()))
//    		return 1;
//    	else if (type.getCode().equals(EligibilityType.PURPLE_HEART_RECIPIENT.getName()))
//    		return 2;
//    	else if (type.getCode().equals(EligibilityType.PURPLE_HEART_RECIPIENT.getName()))
//    		return 3;
//    	else if (type.getCode().equals(EligibilityType.AID_AND_ATTENDANCE.getName()))
//    		return 4;
//    	else if (type.getCode().equals(EligibilityType.HOUSEBOUND.getName()))
//    		return 5;
//    	else if (type.getCode().equals(EligibilityType.NSC_VA_PENSION.getName()))
//    		return 6;
//    	else if (type.getCode().equals(EligibilityType.WORLD_WAR_I.getName()))
//    		return 7;
//    	else if (type.getCode().equals(EligibilityType.HUMANTARIAN_EMERGENCY.getName()))
//    		return 10;
//    	else if (type.getCode().equals(EligibilityType.TRICARE_CHAMPUS.getName()))
//    		return 11;
//    	else if (type.getCode().equals(EligibilityType.SHARING_AGREEMENT.getName()))
//    		return 12;
//    	else if (type.getCode().equals(EligibilityType.ALLIED_VETERAN.getName()))
//    		return 13;
//    	else if (type.getCode().equals(EligibilityType.CHAMPVA.getName()))
//    		return 14;
//    	else if (type.getCode().equals(EligibilityType.EMPLOYEE.getName()))
//    		return 15;
//    	else if (type.getCode().equals(EligibilityType.COLLATERAL_OF_VETERAN.getName()))
//    		return 16;
//    	else if (type.getCode().equals(EligibilityType.OTHER_FEDERAL_AGENCY.getName()))
//    		return 17;
//   	
    }

}