/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/

package gov.va.med.esr.common.model.ee;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.VAFacility;

/**
 * @author Commons Team
 * @version 1.0
 */
public class EGTSiteStatistic extends AbstractKeyedEntity {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -6580986549799247148L;

	private EGTProcessStatistic egtProcessStatistic = null;

	private VAFacility facility = null;

	private Integer beneficiaryProcessedCount = null;

	private Integer beneficiaryNotEnrolledCount = null;

	//Total Veterans Enrolled (Enrollment Category = Enrolled)
	private Integer enrolledCategoryCount = null;
	
	//Total Veterans In-Process -(Enrollment Category = In Process)
	private Integer inProcessCategoryCount = null;

	/**
	 * Creates a new EGTSetting object.
	 */
	public EGTSiteStatistic() {
		super();
	}

	public Integer getBeneficiaryNotEnrolledCount() {
		return beneficiaryNotEnrolledCount;
	}

	public void setBeneficiaryNotEnrolledCount(
			Integer beneficiaryNotEnrolledCount) {
		this.beneficiaryNotEnrolledCount = beneficiaryNotEnrolledCount;
	}

	public EGTProcessStatistic getEgtProcessStatistic() {
		return egtProcessStatistic;
	}

	public void setEgtProcessStatistic(EGTProcessStatistic egtProcessStatistic) {
		this.egtProcessStatistic = egtProcessStatistic;
	}

	public VAFacility getFacility() {
		return facility;
	}

	public void setFacility(VAFacility facility) {
		this.facility = facility;
	}

	private Integer getEnrolledCategoryCount() {
		return enrolledCategoryCount;
	}

	private void setEnrolledCategoryCount(Integer enrolledCategoryCount) {
		this.enrolledCategoryCount = enrolledCategoryCount;
	}

	private Integer getInProcessCategoryCount() {
		return inProcessCategoryCount;
	}

	private void setInProcessCategoryCount(Integer inProcessCategoryCount) {
		this.inProcessCategoryCount = inProcessCategoryCount;
	}

	public Integer getBeneficiaryProcessedCount() {
		return beneficiaryProcessedCount;
	}

	public void setBeneficiaryProcessedCount(Integer beneficiaryProcessedCount) {
		this.beneficiaryProcessedCount = beneficiaryProcessedCount;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("egtProcessStatistic", this.egtProcessStatistic);
		builder.append("facility", this.facility);
		builder.append("beneficiaryNotEnrolledCount",
				this.beneficiaryNotEnrolledCount);
		builder.append("enrolledCategoryCount", this.enrolledCategoryCount);
		builder.append("inProcessCategoryCount",this.inProcessCategoryCount);
		builder.append("beneficiaryProcessedCount",
				this.beneficiaryProcessedCount);
	}

}
