/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/

package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.model.lookup.EGTSettingType;
import gov.va.med.esr.common.model.lookup.EGTStatus;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author Commons Team
 * @version 1.0
 */
public class EGTSetting extends AbstractKeyedEntity {
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = 8605732175868336343L;

    private EGTSettingType type = null;

    private EnrollmentPriorityGroup priorityGroup = null;

    private EnrollmentPrioritySubGroup prioritySubGroup = null;

    private Date effectiveDate = null;

    private Date federalRegisterDate = null;

    private String comments = null;

    private Boolean disable = Boolean.FALSE;

    private Boolean current = Boolean.FALSE;

    private Set internalProcessStatistics = null;

    /** captures the previous active current EGT **/
    private EGTSetting previousEGT = null;

    /**
     * Creates a new EGTSetting object.
     */
    public EGTSetting() {
        super();
    }

    public EGTSettingType getType() {
        return this.type;
    }

    public void setType(EGTSettingType type) {
        this.type = type;
    }

    public EnrollmentPriorityGroup getPriorityGroup() {
        return this.priorityGroup;
    }

    public void setPriorityGroup(EnrollmentPriorityGroup priorityGroup) {
        this.priorityGroup = priorityGroup;
    }

    public EnrollmentPrioritySubGroup getPrioritySubGroup() {
        return this.prioritySubGroup;
    }

    public void setPrioritySubGroup(EnrollmentPrioritySubGroup prioritySubGroup) {
        this.prioritySubGroup = prioritySubGroup;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Boolean getDisable() {
        return disable;
    }

    public void setDisable(Boolean disable) {
        this.disable = disable;
    }

    public Boolean getCurrent() {
        return current;
    }

    public Boolean isCurrent() {
        return getCurrent();
    }
    public void setCurrent(Boolean current) {
        this.current = current;
    }

    public Date getFederalRegisterDate() {
        return federalRegisterDate;
    }

    public void setFederalRegisterDate(Date federalRegisterDate) {
        this.federalRegisterDate = federalRegisterDate;
    }

    private Set getInternalProcessStatistics() {
        if (internalProcessStatistics == null) {
            internalProcessStatistics = new HashSet();
        }
        return internalProcessStatistics;
    }

    private void setInternalProcessStatistics(Set internalProcessStatistics) {
        this.internalProcessStatistics = internalProcessStatistics;
    }

    /**
     * Get the current process statistic record
     * @return
     */
    public EGTProcessStatistic getProcessStatistic() {

        Set processStats = getInternalProcessStatistics();
        if (processStats.size() > 0) {
            return (EGTProcessStatistic) this.internalProcessStatistics.iterator().next();
        }
        return null;
    }

    public void setProcessStatistic(EGTProcessStatistic processStatistic) {
        Set processStats = getInternalProcessStatistics();
        processStats.clear();
        if (processStatistic != null) {
            processStats.add(processStatistic);
            processStatistic.setEgtSetting(this);
        }
    }

    public boolean isProcessCurrentlyRunning()
    {
        EGTProcessStatistic processStatistic = getProcessStatistic();
        if (processStatistic != null)
        {
            EGTStatus egtStatus = processStatistic.getEgtProcessStatus();
            if ((egtStatus != null) && (EGTStatus.CODE_RUNNING.getName().equals(egtStatus.getCode())))
            {
                return true;
            }
        }
        return false;
    }

    public EGTSetting getPreviousEGT() {
        return previousEGT;
    }

    public void setPreviousEGT(EGTSetting previousEGT) {
        this.previousEGT = previousEGT;
    }

    /*
      * (non-Javadoc)
      *
      * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
      */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);

        builder.append("type", this.type);
        builder.append("priorityGroup", this.priorityGroup);
        builder.append("prioritySubGroup", this.prioritySubGroup);
        builder.append("effectiveDate", this.effectiveDate);
        builder.append("federalRegisterDate", this.federalRegisterDate);
        builder.append("disable", this.disable);
        builder.append("current", this.current);
        builder.append("previousEGT", this.previousEGT);
    }
}
