/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/

package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.model.lookup.EGTStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author Commons Team
 * @version 1.0
 */
public class EGTProcessStatistic extends AbstractKeyedEntity {

    private static final long serialVersionUID = 268030912845891022L;
    
	private EGTStatus egtProcessStatus = null;

	private Date processStartDate = null;

	private Date processEndDate = null;

	private Integer beneficiaryProcessedCount = null;

	private Integer beneficiaryNotEnrolledCount = null;

	private String processId = null;
	
	private String processMessage = null;
	
	//Total Veterans Enrolled (Enrollment Category = Enrolled)
	private Integer enrolledCategoryCount = null;
	
	//Total Veterans In-Process -(Enrollment Category = In Process)
	private Integer inProcessCategoryCount = null;

	private EGTSetting egtSetting = null;

	private Map internalSiteStatistics = null;

	/**
	 * Creates a new EGTSetting object.
	 */
	public EGTProcessStatistic() {
		super();
	}




	public Integer getBeneficiaryNotEnrolledCount() {
		return beneficiaryNotEnrolledCount;
	}

	public void setBeneficiaryNotEnrolledCount(
			Integer beneficiaryNotEnrolledCount) {
		this.beneficiaryNotEnrolledCount = beneficiaryNotEnrolledCount;
	}

	public Integer getBeneficiaryProcessedCount() {
		return beneficiaryProcessedCount;
	}

	public void setBeneficiaryProcessedCount(Integer beneficiaryProcessedCount) {
		this.beneficiaryProcessedCount = beneficiaryProcessedCount;
	}

	public Date getProcessEndDate() {
		return processEndDate;
	}

	public void setProcessEndDate(Date processEndDate) {
		this.processEndDate = processEndDate;
	}

	public Date getProcessStartDate() {
		return processStartDate;
	}

	public void setProcessStartDate(Date processStartDate) {
		this.processStartDate = processStartDate;
	}

	public EGTStatus getEgtProcessStatus() {
		return egtProcessStatus;
	}

	public void setEgtProcessStatus(EGTStatus egtProcessStatus) {
		this.egtProcessStatus = egtProcessStatus;
	}

	private Integer getEnrolledCategoryCount() {
		return enrolledCategoryCount;
	}

	private void setEnrolledCategoryCount(Integer enrolledCategoryCount) {
		this.enrolledCategoryCount = enrolledCategoryCount;
	}

	private Integer getInProcessCategoryCount() {
		return inProcessCategoryCount;
	}

	private void setInProcessCategoryCount(Integer inProcessCategoryCount) {
		this.inProcessCategoryCount = inProcessCategoryCount;
	}

	private String getProcessId() {
		return processId;
	}

	private void setProcessId(String processId) {
		this.processId = processId;
	}

	private String getProcessMessage() {
		return processMessage;
	}

	private void setProcessMessage(String processMessage) {
		this.processMessage = processMessage;
	}
	
	public EGTSetting getEgtSetting() {
		return egtSetting;
	}

	public void setEgtSetting(EGTSetting egtSetting) {
		this.egtSetting = egtSetting;
	}

	private Map getInternalSiteStatistics() {
		if (internalSiteStatistics == null) {
			internalSiteStatistics = new HashMap();
		}
		return internalSiteStatistics;
	}

	private void setInternalSiteStatistics(Map internalSiteStatistics) {
		this.internalSiteStatistics = internalSiteStatistics;
	}

	public Map getSiteStatistics() {
		return Collections.unmodifiableMap(getInternalSiteStatistics());
	}
	
	public EGTSiteStatistic getSiteStatistics(VAFacility site) {
		return (EGTSiteStatistic) this.getInternalSiteStatistics().get(site);
	}

	public void setEGTSiteStatistic(VAFacility facility, EGTSiteStatistic siteStats) {
		Validate.notNull(facility, "Reported Site cannot be null");

		EGTSiteStatistic currentSiteStats = this.getSiteStatistics(facility);
		if (currentSiteStats != siteStats) {
			if (currentSiteStats != null) {
				getInternalSiteStatistics().remove(facility);
				currentSiteStats.setEgtProcessStatistic(null);
			}
			if (siteStats != null) {
				if (siteStats.getFacility() != null) {
					Validate.isTrue(facility.equals(siteStats
							.getFacility()), "Parameter Facility must match with the facility in the EGTSiteStatistic Object.");
				}
				else {
					siteStats.setFacility(facility);
				}

				siteStats.setEgtProcessStatistic(this);
				getInternalSiteStatistics().put(facility, siteStats);
			}
		}
	}

	/**
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);

		builder.append("processStartDate", this.processStartDate);
		builder.append("processEndDate", this.processEndDate);
		builder.append("egtProcessStatus", this.egtProcessStatus);
		builder.append("beneficiaryProcessedCount",
				this.beneficiaryProcessedCount);
		builder.append("beneficiaryNotEnrolledCount",
				this.beneficiaryNotEnrolledCount);
		builder.append("processId", this.processId);
		builder.append("processMessage", this.processMessage);
		builder.append("enrolledCategoryCount", this.enrolledCategoryCount);
		builder.append("inProcessCategoryCount",this.inProcessCategoryCount);
		
	}


}

